/*
 * Decompiled with CFR 0.152.
 */
package beowulf.gui;

import beowulf.event.GraphEvent;
import beowulf.event.GraphListener;
import beowulf.gui.DraggableComponent;
import beowulf.gui.DraggableContainer;
import beowulf.gui.JNode;
import beowulf.gui.JNodeFactory;
import beowulf.model.graph.AbstractGraphModel;
import beowulf.model.graph.DirectedGraph;
import beowulf.model.graph.Edge;
import beowulf.model.graph.GraphModel;
import beowulf.model.graph.UndirectedGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;

public class JGraph
extends DraggableContainer
implements GraphListener {
    private static final long serialVersionUID = 3257845493651617334L;
    public static final int DIRECTED_GRAPH = 1;
    public static final int UNDIRECTED_GRAPH = 2;
    public static final float HEAD = 15.0f;
    private static GeneralPath halfArrowPath1 = JGraph.createHalfArrow1();
    private static GeneralPath halfArrowPath2 = JGraph.createHalfArrow2();
    protected GraphModel model;
    protected Map nodeLookup;
    protected JNodeFactory factory;
    private final int[] drawEdge_xVals = new int[4];
    private final int[] drawEdge_yVals = new int[4];
    private final AffineTransform drawEdge_at = new AffineTransform();
    private final float[] getPolyPoints_dummy = new float[2];

    private static GeneralPath createHalfArrow1() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(15.0f, 0.0f);
        generalPath.lineTo(0.0f, 7.5f);
        generalPath.closePath();
        return generalPath;
    }

    private static GeneralPath createHalfArrow2() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(15.0f, 0.0f);
        generalPath.lineTo(15.0f, -7.5f);
        generalPath.lineTo(0.0f, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    public void setModel(GraphModel graphModel) {
        this.removeAll();
        if (this.model != null) {
            this.model.removeGraphListener(this);
        }
        this.model = graphModel;
        graphModel.addGraphListener(this);
        this.nodeLookup = this.model.getUseDotEquals() ? new Hashtable() : new IdentityHashMap();
        Vector vector = this.model.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            JNode jNode = this.factory.produceJNode(e);
            DraggableComponent draggableComponent = new DraggableComponent(this, jNode);
            this.add(draggableComponent);
            this.nodeLookup.put(e, draggableComponent);
        }
    }

    public void setModel(int n) {
        switch (n) {
            case 1: {
                this.setModel(new DirectedGraph());
                break;
            }
            case 2: {
                this.setModel(new UndirectedGraph());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Graph Type");
            }
        }
    }

    public void setJNodeFactory(JNodeFactory jNodeFactory) {
        this.factory = jNodeFactory;
    }

    public GraphModel getModel() {
        return this.model;
    }

    public JNodeFactory getJNodeFactory() {
        return this.factory;
    }

    public JGraph() {
        this(1);
    }

    public JGraph(int n) {
        this(n, new JNodeFactory());
    }

    public JGraph(int n, JNodeFactory jNodeFactory) {
        this.setJNodeFactory(jNodeFactory);
        this.setModel(n);
    }

    public JGraph(AbstractGraphModel abstractGraphModel) {
        this(abstractGraphModel, new JNodeFactory());
    }

    public JGraph(AbstractGraphModel abstractGraphModel, JNodeFactory jNodeFactory) {
        this.setJNodeFactory(jNodeFactory);
        this.setModel(abstractGraphModel);
    }

    public JGraph(Vector vector, Vector vector2, int n) {
        this(vector, vector2, n, new JNodeFactory());
    }

    public JGraph(Vector vector, Vector vector2, int n, JNodeFactory jNodeFactory) {
        int n2;
        this.setJNodeFactory(jNodeFactory);
        this.setModel(n);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            ((AbstractGraphModel)this.model).addNode(vector.get(n2));
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            ((AbstractGraphModel)this.model).addEdge((Edge)vector2.get(n2));
        }
    }

    public void nodeAdded(GraphEvent graphEvent) {
        JNode jNode = this.factory.produceJNode(graphEvent.getNodeValue());
        DraggableComponent draggableComponent = new DraggableComponent(this, jNode);
        this.add(draggableComponent);
        this.nodeLookup.put(graphEvent.getNodeValue(), draggableComponent);
        this.repaint();
    }

    public void nodeRemoved(GraphEvent graphEvent) {
        Component[] componentArray = this.getComponents();
        DraggableComponent draggableComponent = null;
        for (int i = 0; i < componentArray.length; ++i) {
            try {
                draggableComponent = (DraggableComponent)componentArray[i];
            }
            catch (Exception exception) {
                continue;
            }
            if (((JNode)draggableComponent.getComponent()).getValue().equals(graphEvent.getNodeValue())) break;
        }
        if (draggableComponent != null) {
            this.remove(draggableComponent);
            this.nodeLookup.remove(graphEvent.getNodeValue());
        }
        this.repaint();
    }

    public void edgeAdded(GraphEvent graphEvent) {
        this.repaint();
    }

    public void edgeRemoved(GraphEvent graphEvent) {
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.model == null) {
            return;
        }
        if (this.model.isDirected()) {
            this.paintDirected(graphics);
        } else {
            this.paintUndirected(graphics);
        }
    }

    private void paintUndirected(Graphics graphics) {
        Vector vector = this.model.getNodes();
        Edge edge = null;
        for (int i = 0; i < vector.size(); ++i) {
            for (int j = 0; j <= i; ++j) {
                Vector vector2 = this.model.getEdgesFromTo(vector.get(i), vector.get(j));
                if (vector2.size() == 0) continue;
                String string = null;
                for (int k = 0; k < vector2.size(); ++k) {
                    edge = (Edge)vector2.get(k);
                    string = string == null ? edge.getCost().toString() : string + ", " + edge.getCost().toString();
                }
                if (i == j) {
                    this.drawSelfEdge((Graphics2D)graphics, (DraggableComponent)this.nodeLookup.get(vector.get(j)), string);
                    continue;
                }
                this.drawUndirectedEdge((Graphics2D)graphics, (DraggableComponent)this.nodeLookup.get(vector.get(i)), (DraggableComponent)this.nodeLookup.get(vector.get(j)), string);
            }
        }
    }

    private void drawUndirectedEdge(Graphics2D graphics2D, DraggableComponent draggableComponent, DraggableComponent draggableComponent2, String string) {
        DraggableComponent draggableComponent3;
        DraggableComponent draggableComponent4;
        Color color = graphics2D.getColor();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (draggableComponent.getX() < draggableComponent2.getX()) {
            draggableComponent4 = draggableComponent;
            draggableComponent3 = draggableComponent2;
        } else {
            draggableComponent4 = draggableComponent2;
            draggableComponent3 = draggableComponent;
        }
        DraggableComponent draggableComponent5 = draggableComponent.getY() < draggableComponent2.getY() ? draggableComponent : draggableComponent2;
        graphics2D.setColor(Color.black);
        if (draggableComponent5 == draggableComponent3) {
            int n = (draggableComponent4.getX() + draggableComponent4.getWidth() - 2 + draggableComponent3.getX() + 1) / 2;
            int n2 = (draggableComponent4.getY() + 1 + draggableComponent3.getY() + draggableComponent3.getHeight() - 2) / 2;
            graphics2D.drawString(string, n - fontMetrics.stringWidth(string), n2 - fontMetrics.getDescent());
            graphics2D.drawLine(draggableComponent4.getX() + draggableComponent4.getWidth() - 2, draggableComponent4.getY() + 1, draggableComponent3.getX() + 1, draggableComponent3.getY() + draggableComponent3.getHeight() - 2);
        } else {
            int n = (draggableComponent4.getX() + draggableComponent4.getWidth() - 2 + draggableComponent3.getX() + 1) / 2;
            int n3 = (draggableComponent4.getY() + draggableComponent4.getHeight() - 2 + draggableComponent3.getY() + 1) / 2;
            graphics2D.drawString(string, n, n3 - fontMetrics.getDescent());
            graphics2D.drawLine(draggableComponent4.getX() + draggableComponent4.getWidth() - 2, draggableComponent4.getY() + draggableComponent4.getHeight() - 2, draggableComponent3.getX() + 1, draggableComponent3.getY() + 1);
        }
        graphics2D.setColor(color);
    }

    private void paintDirected(Graphics graphics) {
        Vector vector = this.model.getNodes();
        Edge edge = null;
        for (int i = 0; i < vector.size(); ++i) {
            for (int j = 0; j <= i; ++j) {
                int n;
                Vector vector2 = this.model.getEdgesFromTo(vector.get(i), vector.get(j));
                if (vector2.size() == 0 && i == j) continue;
                String string = null;
                for (n = 0; n < vector2.size(); ++n) {
                    edge = (Edge)vector2.get(n);
                    string = string == null ? edge.getCost().toString() : string + ", " + edge.getCost().toString();
                }
                if (i == j) {
                    this.drawEdge((Graphics2D)graphics, (DraggableComponent)this.nodeLookup.get(vector.get(i)), (DraggableComponent)this.nodeLookup.get(vector.get(j)), string, null);
                    continue;
                }
                vector2 = this.model.getEdgesFromTo(vector.get(j), vector.get(i));
                if (vector2.size() == 0 && string == null) continue;
                String string2 = null;
                for (n = 0; n < vector2.size(); ++n) {
                    edge = (Edge)vector2.get(n);
                    string2 = string2 == null ? edge.getCost().toString() : string2 + ", " + edge.getCost().toString();
                }
                this.drawEdge((Graphics2D)graphics, (DraggableComponent)this.nodeLookup.get(vector.get(i)), (DraggableComponent)this.nodeLookup.get(vector.get(j)), string, string2);
            }
        }
    }

    private void drawSelfEdge(Graphics2D graphics2D, DraggableComponent draggableComponent, String string) {
        Color color = graphics2D.getColor();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(Color.black);
        int n = ((JNode)draggableComponent.getComponent()).getRadius();
        if (n < 0) {
            n = (int)Math.rint(2.0 * (double)draggableComponent.getWidth() / 5.0);
        }
        int n2 = draggableComponent.getX() + draggableComponent.getWidth() / 2 - n - 1;
        int n3 = draggableComponent.getY() - 2 * n - 1 + draggableComponent.getHeight() / 2;
        double d = Math.acos(((double)n - (double)draggableComponent.getHeight() / 2.0) / (double)n) * 180.0 / Math.PI;
        graphics2D.drawArc(n2, n3, n * 2, n * 2, (int)(270.0 + d), (int)(360.0 - 2.0 * d));
        graphics2D.drawString(string, draggableComponent.getX() + draggableComponent.getWidth() / 2 - fontMetrics.stringWidth(string) / 2, draggableComponent.getY() - 2 * n - 1 - fontMetrics.getDescent());
        graphics2D.setColor(color);
    }

    private void drawEdge(Graphics2D graphics2D, DraggableComponent draggableComponent, DraggableComponent draggableComponent2, String string, String string2) {
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        int n3;
        int n4;
        DraggableComponent draggableComponent3;
        DraggableComponent draggableComponent4;
        if (draggableComponent == draggableComponent2) {
            this.drawSelfEdge(graphics2D, draggableComponent, string);
            return;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Color color = graphics2D.getColor();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (draggableComponent.getX() < draggableComponent2.getX()) {
            draggableComponent4 = draggableComponent;
            draggableComponent3 = draggableComponent2;
        } else {
            draggableComponent4 = draggableComponent2;
            draggableComponent3 = draggableComponent;
        }
        DraggableComponent draggableComponent5 = draggableComponent.getY() < draggableComponent2.getY() ? draggableComponent : draggableComponent2;
        if (draggableComponent == draggableComponent3) {
            String string3 = string;
            string = string2;
            string2 = string3;
        }
        if (draggableComponent5 == draggableComponent3) {
            n4 = draggableComponent4.getX() + draggableComponent4.getWidth() - 2;
            n3 = draggableComponent4.getY() + 1;
            n2 = draggableComponent3.getX() + 1;
            n = draggableComponent3.getY() + draggableComponent3.getHeight() - 2;
            d3 = n - n3;
            d2 = n2 - n4;
            d = Math.sqrt(d3 * d3 + d2 * d2);
            double d8 = Math.atan2(d3 / d, d2 / d);
            int n9 = (n4 + n2) / 2;
            int n10 = (n3 + n) / 2;
            if (string != null) {
                d4 = (double)n4 + d2 - 15.0 * Math.cos(d8);
                d5 = (double)n3 + d3 - 15.0 * Math.sin(d8);
                n5 = n9;
                n6 = d3 * d2 > 0.0 ? n10 - fontMetrics.getDescent() : n10 + fontMetrics.getLeading() + fontMetrics.getAscent();
            }
            if (string2 != null) {
                d6 = n4;
                d7 = n3;
                n7 = n9 - fontMetrics.stringWidth(string2);
                n8 = d3 * d2 > 0.0 ? n10 + fontMetrics.getLeading() + fontMetrics.getAscent() : n10 - fontMetrics.getDescent();
            }
        } else {
            n4 = draggableComponent4.getX() + draggableComponent4.getWidth() - 2;
            n3 = draggableComponent4.getY() + draggableComponent4.getHeight() - 2;
            n2 = draggableComponent3.getX() + 1;
            n = draggableComponent3.getY() + 1;
            d3 = n - n3;
            d2 = n2 - n4;
            d = Math.sqrt(d3 * d3 + d2 * d2);
            double d9 = Math.atan2(d3 / d, d2 / d);
            int n11 = (n4 + n2) / 2;
            int n12 = (n3 + n) / 2;
            if (string != null) {
                d4 = (double)n4 + d2 - 15.0 * Math.cos(d9);
                d5 = (double)n3 + d3 - 15.0 * Math.sin(d9);
                n5 = n11 - fontMetrics.stringWidth(string);
                n6 = d3 * d2 < 0.0 ? n12 - fontMetrics.getDescent() : n12 + fontMetrics.getLeading() + fontMetrics.getAscent();
            }
            if (string2 != null) {
                d6 = n4;
                d7 = n3;
                n7 = n11;
                n8 = d3 * d2 < 0.0 ? n12 + fontMetrics.getLeading() + fontMetrics.getAscent() : n12 - fontMetrics.getDescent();
            }
        }
        graphics2D.setColor(Color.black);
        d2 /= d;
        d3 /= d;
        if (string != null) {
            this.drawEdge_at.setToIdentity();
            this.drawEdge_at.setTransform(d2, d3, -d3, d2, d4, d5);
            this.getPolyPoints(this.drawEdge_at, halfArrowPath1, this.drawEdge_xVals, this.drawEdge_yVals);
            graphics2D.fillPolygon(this.drawEdge_xVals, this.drawEdge_yVals, 3);
            graphics2D.drawString(string, n5, n6);
        }
        if (string2 != null) {
            this.drawEdge_at.setToIdentity();
            this.drawEdge_at.setTransform(d2, d3, -d3, d2, d6, d7);
            this.getPolyPoints(this.drawEdge_at, halfArrowPath2, this.drawEdge_xVals, this.drawEdge_yVals);
            graphics2D.fillPolygon(this.drawEdge_xVals, this.drawEdge_yVals, 3);
            graphics2D.drawString(string2, n7, n8);
        }
        graphics2D.drawLine(n4, n3, n2, n);
        graphics2D.setColor(color);
    }

    private void getPolyPoints(AffineTransform affineTransform, GeneralPath generalPath, int[] nArray, int[] nArray2) {
        PathIterator pathIterator = generalPath.getPathIterator(affineTransform);
        int n = 0;
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(this.getPolyPoints_dummy);
            nArray[n] = (int)Math.rint(this.getPolyPoints_dummy[0]);
            nArray2[n] = (int)Math.rint(this.getPolyPoints_dummy[1]);
            pathIterator.next();
            ++n;
        }
    }
}

