/*
 * Decompiled with CFR 0.152.
 */
package beowulf.gui;

import beowulf.gui.DCMouseEventReceiver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class JNode
extends JLabel
implements ActionListener,
DCMouseEventReceiver {
    private static final long serialVersionUID = 3760845645065499700L;
    protected static final Object[] EMPTY_PARAM_LIST = new Object[0];
    protected static final Object[] SINGLE_PARAM_LIST = new Object[1];
    protected static final Class[] EMPTY_PARAM_CLASS_LIST = new Class[0];
    protected static final Class[] SINGLE_PARAM_CLASS_LIST = new Class[1];
    protected static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    protected static final String SHOW_PROPERTIES = "Show Properties";
    protected Object value;
    protected JPopupMenu menu;
    protected PropertiesWindow propertiesWindow;
    protected int radius = -1;

    public Object getValue() {
        return this.value;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public JNode(Object object) {
        this.value = object;
        this.setText(this.value.toString());
        this.makePopupMenu();
    }

    protected void makePopupMenu() {
        this.menu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(SHOW_PROPERTIES);
        jMenuItem.addActionListener(this);
        this.menu.add(jMenuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals(SHOW_PROPERTIES)) {
            this.showProperties();
        }
    }

    public void showProperties() {
        if (this.propertiesWindow == null) {
            this.propertiesWindow = new PropertiesWindow();
        }
        this.propertiesWindow.setVisible(true);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.menu != null) {
            this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.menu != null) {
            this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public class PropertiesWindow
    extends JFrame
    implements ActionListener {
        private static final long serialVersionUID = 3832902169505379635L;
        protected static final String OK_BUTTON_TEXT = "Ok";
        protected static final String CANCEL_BUTTON_TEXT = "Cancel";
        public static final String INT_TYPE = "int";
        public static final String STRING_TYPE = "String";
        public static final String BOOL_TYPE = "bool";
        public static final String DOUBLE_TYPE = "double";
        protected Method[] accessors;
        protected Method[] modifiers;
        protected String[] fieldNames;
        protected String[] fieldTypes;
        protected JComponent[] fieldEntrys;
        protected boolean neverShownBefore;

        public PropertiesWindow() {
            super(JNode.this.getText());
            this.neverShownBefore = true;
        }

        protected void setupFields() {
            this.accessors = new Method[1];
            this.modifiers = new Method[1];
            this.fieldNames = new String[1];
            this.fieldTypes = new String[1];
            try {
                this.accessors[0] = JNode.this.getClass().getMethod("getRadius", EMPTY_PARAM_CLASS_LIST);
                JNode.SINGLE_PARAM_CLASS_LIST[0] = Integer.TYPE;
                this.modifiers[0] = JNode.this.getClass().getMethod("setRadius", SINGLE_PARAM_CLASS_LIST);
                this.fieldNames[0] = "Radius";
                this.fieldTypes[0] = INT_TYPE;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println(noSuchMethodException);
            }
        }

        protected JComponent makeCenterPanel() {
            JPanel jPanel = new JPanel(new GridLayout(this.fieldNames.length, 2));
            this.fieldEntrys = new JComponent[this.fieldNames.length];
            for (int i = 0; i < this.fieldNames.length; ++i) {
                JLabel jLabel = new JLabel(this.fieldNames[i]);
                jPanel.add(jLabel);
                if (this.fieldTypes[i].equals(INT_TYPE)) {
                    this.fieldEntrys[i] = new JTextField();
                } else if (this.fieldTypes[i].equals(STRING_TYPE)) {
                    this.fieldEntrys[i] = new JTextField();
                } else if (this.fieldTypes[i].equals(BOOL_TYPE)) {
                    this.fieldEntrys[i] = new JCheckBox();
                } else if (this.fieldTypes[i].equals(DOUBLE_TYPE)) {
                    this.fieldEntrys[i] = new JTextField();
                }
                jPanel.add(this.fieldEntrys[i]);
            }
            return jPanel;
        }

        protected JComponent makeBottomPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)new JPanel(), "Center");
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            JButton jButton = new JButton(OK_BUTTON_TEXT);
            jButton.addActionListener(this);
            jPanel2.add(jButton);
            jButton = new JButton(CANCEL_BUTTON_TEXT);
            jButton.addActionListener(this);
            jPanel2.add(jButton);
            jPanel.add((Component)jPanel2, "East");
            return jPanel;
        }

        public void setVisible(boolean bl) {
            if (bl) {
                if (this.neverShownBefore) {
                    Container container = this.getContentPane();
                    container.setLayout(new BorderLayout());
                    this.setupFields();
                    container.add((Component)this.makeCenterPanel(), "Center");
                    container.add((Component)this.makeBottomPanel(), "South");
                    this.pack();
                    this.setLocation((int)(SCREEN_SIZE.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(SCREEN_SIZE.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
                    this.setResizable(false);
                    this.neverShownBefore = false;
                }
                this.setTitle(JNode.this.getText());
                for (int i = 0; i < this.fieldNames.length; ++i) {
                    if (this.fieldTypes[i].equals(INT_TYPE)) {
                        try {
                            ((JTextField)this.fieldEntrys[i]).setText(this.accessors[i].invoke((Object)JNode.this, EMPTY_PARAM_LIST).toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println(illegalAccessException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println(invocationTargetException);
                        }
                        continue;
                    }
                    if (this.fieldTypes[i].equals(STRING_TYPE)) {
                        try {
                            ((JTextField)this.fieldEntrys[i]).setText(this.accessors[i].invoke((Object)JNode.this, EMPTY_PARAM_LIST).toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println(illegalAccessException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println(invocationTargetException);
                        }
                        continue;
                    }
                    if (this.fieldTypes[i].equals(BOOL_TYPE)) {
                        try {
                            Boolean bl2 = (Boolean)this.accessors[i].invoke((Object)JNode.this, EMPTY_PARAM_LIST);
                            ((JCheckBox)this.fieldEntrys[i]).setSelected(bl2);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println(illegalAccessException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println(invocationTargetException);
                        }
                        continue;
                    }
                    if (!this.fieldTypes[i].equals(DOUBLE_TYPE)) continue;
                    try {
                        ((JTextField)this.fieldEntrys[i]).setText(this.accessors[i].invoke((Object)JNode.this, EMPTY_PARAM_LIST).toString());
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println(illegalAccessException);
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.out.println(invocationTargetException);
                    }
                }
            }
            super.setVisible(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.equals(OK_BUTTON_TEXT)) {
                    this.okButtonPressed();
                } else if (string.equals(CANCEL_BUTTON_TEXT)) {
                    this.cancelButtonPressed();
                }
            }
        }

        protected void cancelButtonPressed() {
            this.setVisible(false);
        }

        protected void okButtonPressed() {
            for (int i = 0; i < this.fieldNames.length; ++i) {
                if (this.fieldTypes[i].equals(INT_TYPE)) {
                    try {
                        JNode.SINGLE_PARAM_LIST[0] = new Integer(((JTextField)this.fieldEntrys[i]).getText());
                        this.modifiers[i].invoke((Object)JNode.this, SINGLE_PARAM_LIST);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.out.println(invocationTargetException);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (this.fieldTypes[i].equals(BOOL_TYPE)) {
                    try {
                        JNode.SINGLE_PARAM_LIST[0] = ((JCheckBox)this.fieldEntrys[i]).isSelected() ? Boolean.TRUE : Boolean.FALSE;
                        this.modifiers[i].invoke((Object)JNode.this, SINGLE_PARAM_LIST);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.out.println(invocationTargetException);
                    }
                    continue;
                }
                if (this.fieldTypes[i].equals(STRING_TYPE)) {
                    try {
                        JNode.SINGLE_PARAM_LIST[0] = new String(((JTextField)this.fieldEntrys[i]).getText());
                        this.modifiers[i].invoke((Object)JNode.this, SINGLE_PARAM_LIST);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.out.println(invocationTargetException);
                    }
                    continue;
                }
                if (!this.fieldTypes[i].equals(DOUBLE_TYPE)) continue;
                try {
                    JNode.SINGLE_PARAM_LIST[0] = new Double(((JTextField)this.fieldEntrys[i]).getText());
                    this.modifiers[i].invoke((Object)JNode.this, SINGLE_PARAM_LIST);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println(illegalAccessException);
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println(invocationTargetException);
                }
            }
            this.setVisible(false);
        }
    }
}

