/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class Matrix
implements Collection,
Serializable {
    private static final long serialVersionUID = 3906647518254150197L;
    protected Object[][] data;
    protected int numRows = 0;
    protected int numCols = 0;
    protected Object defaultValue;

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getCols() {
        return this.numCols;
    }

    public Matrix() {
        this(1, 1, null);
    }

    public Matrix(Object object) {
        this(1, 1, object);
    }

    public Matrix(int n) {
        this(n, n, null);
    }

    public Matrix(int n, Object object) {
        this(n, n, object);
    }

    public Matrix(int n, int n2) {
        this(n, n2, null);
    }

    public Matrix(int n, int n2, Object object) {
        this.expandTo(n, n2);
        this.setDefaultValue(object);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.data[i][j] = this.getDefaultValue();
            }
        }
    }

    public void removeRow(int n) {
        for (int i = 0; i < this.numCols; ++i) {
            this.remove(n, i);
        }
    }

    public void removeCol(int n) {
        for (int i = 0; i < this.numRows; ++i) {
            this.remove(i, n);
        }
    }

    public void remove(int n) {
        this.removeCol(n);
        this.removeRow(n);
    }

    public void remove(int n, int n2) {
        this.data[n][n2] = this.getDefaultValue();
    }

    public void expandTo(int n) {
        this.expandTo(n, n);
    }

    public void expandTo(int n, int n2) {
        int n3 = Math.min(this.numRows, n);
        int n4 = Math.min(this.numCols, n2);
        Object[][] objectArrayArray = new Object[n][];
        for (int i = 0; i < n; ++i) {
            objectArrayArray[i] = new Object[n2];
            for (int j = 0; j < n2; ++j) {
                objectArrayArray[i][j] = i >= n3 || j >= n4 ? this.getDefaultValue() : this.data[i][j];
            }
        }
        this.numRows = n;
        this.numCols = n2;
        this.data = objectArrayArray;
    }

    public void expandBy(int n) {
        this.expandBy(n, n);
    }

    public void expandBy(int n, int n2) {
        this.expandTo(n + this.numRows, n2 + this.numCols);
    }

    public Object get(int n, int n2) {
        return this.data[n][n2];
    }

    public void put(int n, int n2, Object object) {
        this.data[n][n2] = object;
    }

    public void add(int n, int n2, Object object) {
        while (n >= this.numRows || n2 >= this.numCols) {
            this.expandTo(2 * this.numRows + 1, 2 * this.numCols + 1);
        }
        this.put(n, n2, object);
    }

    public Object getDefaultValue() {
        try {
            return this.defaultValue.getClass().newInstance();
        }
        catch (Exception exception) {
            return this.defaultValue;
        }
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public int size() {
        return this.numRows * this.numCols;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                if (this.data[i][j] == null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean add(Object object) {
        return false;
    }

    public boolean addAll(Collection collection) {
        return false;
    }

    public boolean remove(Object object) {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                if (!this.data[i][j].equals(object)) continue;
                this.remove(i, j);
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.data = new Object[1][1];
        this.numRows = 1;
        this.numCols = 1;
        this.data[0][0] = this.getDefaultValue();
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                if (this.data[i][j] == null || collection.contains(this.data[i][j])) continue;
                this.remove(i, j);
                bl = true;
            }
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean contains(Object object) {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                if (!this.data[i][j].equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        return new Iterator(){
            int rowCtr = 0;
            int colCtr = -1;

            public boolean hasNext() {
                do {
                    ++this.colCtr;
                    if (this.colCtr < Matrix.this.numCols) continue;
                    this.colCtr = 0;
                    ++this.rowCtr;
                } while (this.rowCtr < Matrix.this.numRows && Matrix.this.data[this.rowCtr][this.colCtr] == null);
                return this.rowCtr < Matrix.this.numRows;
            }

            public Object next() {
                return Matrix.this.data[this.rowCtr][this.colCtr];
            }

            public void remove() {
            }
        };
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.numRows * this.numCols) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.numRows * this.numCols);
        }
        for (int i = 0; i < this.numRows; ++i) {
            System.arraycopy(this.data[i], 0, objectArray, i * this.numCols, this.numCols);
        }
        if (objectArray.length > this.numRows * this.numCols) {
            objectArray[this.numRows * this.numCols] = null;
        }
        return objectArray;
    }
}

