/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.graph;

import beowulf.event.GraphEvent;
import beowulf.event.GraphListener;
import beowulf.model.graph.Edge;
import beowulf.model.graph.GraphModel;
import java.io.Serializable;
import java.util.Vector;

public abstract class AbstractGraphModel
implements GraphModel,
Serializable {
    protected transient Vector listenerList = new Vector();

    public void addGraphListener(GraphListener graphListener) {
        this.listenerList.add(graphListener);
    }

    public void removeGraphListener(GraphListener graphListener) {
        this.listenerList.remove(graphListener);
    }

    protected void fireNodeAdded(GraphModel graphModel, Object object) {
        GraphEvent graphEvent = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            if (graphEvent == null) {
                graphEvent = new GraphEvent(graphModel, 1, object);
            }
            ((GraphListener)this.listenerList.get(i)).nodeAdded(graphEvent);
        }
    }

    protected void fireNodeRemoved(GraphModel graphModel, Object object) {
        GraphEvent graphEvent = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            if (graphEvent == null) {
                graphEvent = new GraphEvent(graphModel, 2, object);
            }
            ((GraphListener)this.listenerList.get(i)).nodeRemoved(graphEvent);
        }
    }

    protected void fireEdgeAdded(GraphModel graphModel, Edge edge) {
        GraphEvent graphEvent = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            if (graphEvent == null) {
                graphEvent = new GraphEvent(graphModel, 3, edge);
            }
            ((GraphListener)this.listenerList.get(i)).edgeAdded(graphEvent);
        }
    }

    protected void fireEdgeRemoved(GraphModel graphModel, Edge edge) {
        GraphEvent graphEvent = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            if (graphEvent == null) {
                graphEvent = new GraphEvent(graphModel, 4, edge);
            }
            ((GraphListener)this.listenerList.get(i)).edgeRemoved(graphEvent);
        }
    }

    public Vector getGraphListeners() {
        return this.listenerList;
    }

    public abstract void removeNode(Object var1);

    public abstract void addNode(Object var1);

    public abstract Object removeEdge(Edge var1);

    public abstract Object removeEdge(Object var1, Object var2, Object var3);

    public abstract void addEdge(Object var1, Object var2, Object var3);

    public abstract void addEdge(Edge var1);
}

