/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.graph;

import beowulf.model.Matrix;
import beowulf.model.graph.AbstractGraphModel;
import beowulf.model.graph.Edge;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;

public class UndirectedGraph
extends AbstractGraphModel {
    private static final long serialVersionUID = 3258131366640955449L;
    protected Matrix transitionMatrix;
    protected Vector nodeList;
    protected Vector edgeList;
    protected Map valueToIndex;
    protected Vector usedIndices;
    protected boolean useDotEquals = true;

    public boolean getUseDotEquals() {
        return this.useDotEquals;
    }

    public UndirectedGraph() {
        this(true);
    }

    public UndirectedGraph(boolean bl) {
        this.useDotEquals = bl;
        this.transitionMatrix = new Matrix(5, new Vector());
        this.nodeList = new Vector();
        this.usedIndices = new Vector();
        this.valueToIndex = this.useDotEquals ? new Hashtable() : new IdentityHashMap();
        this.edgeList = new Vector();
    }

    private int useNextLowestIndex() {
        int n = 0;
        int n2 = 0;
        while (this.usedIndices.contains(new Integer(n))) {
            n = ++n2;
        }
        this.usedIndices.add(new Integer(n));
        return n;
    }

    private void returnIndex(int n) {
        this.usedIndices.remove(new Integer(n));
    }

    private int findNodeIndexByValue(Object object) {
        Integer n = (Integer)this.valueToIndex.get(object);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public Vector getNodes() {
        return this.nodeList;
    }

    public Vector getEdges() {
        return this.edgeList;
    }

    public int getNodeCount() {
        return this.nodeList.size();
    }

    public int getEdgeCount() {
        return this.edgeList.size();
    }

    public boolean isDirected() {
        return false;
    }

    public boolean isSimple() {
        for (int i = 0; i < this.transitionMatrix.getRows(); ++i) {
            for (int j = 0; j <= i; ++j) {
                if (!(i == j ? ((Vector)this.transitionMatrix.get(i, j)).size() != 0 : ((Vector)this.transitionMatrix.get(i, j)).size() > 1)) continue;
                return false;
            }
        }
        return true;
    }

    public Vector getEdgesFromTo(Object object, Object object2) {
        return (Vector)this.transitionMatrix.get(this.findNodeIndexByValue(object), this.findNodeIndexByValue(object2));
    }

    public Vector getEdgesFrom(Object object) {
        Vector vector = new Vector();
        int n = this.findNodeIndexByValue(object);
        for (int i = 0; i < this.transitionMatrix.getCols(); ++i) {
            vector.addAll((Vector)this.transitionMatrix.get(n, i));
        }
        return vector;
    }

    public Vector getEdgesTo(Object object) {
        Vector vector = new Vector();
        int n = this.findNodeIndexByValue(object);
        for (int i = 0; i < this.transitionMatrix.getRows(); ++i) {
            vector.addAll((Vector)this.transitionMatrix.get(i, n));
        }
        return vector;
    }

    public void removeNode(Object object) {
        Vector vector;
        int n;
        int n2 = this.findNodeIndexByValue(object);
        for (n = 0; n < this.transitionMatrix.getRows(); ++n) {
            vector = (Vector)this.transitionMatrix.get(n2, n);
            while (vector.size() > 0) {
                this.removeEdge((Edge)vector.get(0));
            }
        }
        for (n = 0; n < this.transitionMatrix.getRows(); ++n) {
            vector = (Vector)this.transitionMatrix.get(n, n2);
            while (vector.size() > 0) {
                this.removeEdge((Edge)vector.get(0));
            }
        }
        int n3 = -1;
        Object var6_6 = null;
        for (n = 0; n < this.nodeList.size(); ++n) {
            if (this.nodeList.get(n) == null) continue;
            n3 = n;
            var6_6 = this.nodeList.get(n);
        }
        if (n3 == -1 || n3 == n2) {
            this.nodeList.removeElementAt(n2);
            this.returnIndex(n2);
            this.valueToIndex.remove(object);
        } else {
            this.nodeList.set(n2, this.nodeList.get(n3));
            this.nodeList.removeElementAt(n3);
            this.valueToIndex.remove(object);
            this.valueToIndex.remove(var6_6);
            this.valueToIndex.put(this.nodeList.get(n2), new Integer(n2));
            this.returnIndex(n3);
            for (n = 0; n < this.transitionMatrix.getRows(); ++n) {
                vector = (Vector)this.transitionMatrix.get(n, n3);
                this.transitionMatrix.put(n, n3, this.transitionMatrix.get(n, n2));
                this.transitionMatrix.put(n, n2, vector);
            }
            for (n = 0; n < this.transitionMatrix.getCols(); ++n) {
                vector = (Vector)this.transitionMatrix.get(n3, n);
                this.transitionMatrix.put(n3, n, this.transitionMatrix.get(n2, n));
                this.transitionMatrix.put(n2, n, vector);
            }
        }
        this.fireNodeRemoved(this, object);
    }

    public void addNode(Object object) {
        if (this.nodeList.contains(object)) {
            throw new RuntimeException("Node already contained in graph!");
        }
        int n = this.useNextLowestIndex();
        if (n >= this.transitionMatrix.getRows()) {
            this.transitionMatrix.expandBy(this.transitionMatrix.getRows());
        }
        if (n >= this.nodeList.size()) {
            this.nodeList.add(object);
        } else {
            this.nodeList.set(n, object);
        }
        this.valueToIndex.put(object, new Integer(n));
        this.fireNodeAdded(this, object);
    }

    public Object removeEdge(Edge edge) {
        return this.removeEdge(edge.getSourceValue(), edge.getDestinationValue(), edge.getCost());
    }

    public Object removeEdge(Object object, Object object2, Object object3) {
        Edge edge = new Edge(object, object2, object3);
        int n = this.findNodeIndexByValue(object);
        int n2 = this.findNodeIndexByValue(object2);
        Vector vector = null;
        vector = n < n2 ? (Vector)this.transitionMatrix.get(n2, n) : (Vector)this.transitionMatrix.get(n, n2);
        int n3 = vector.indexOf(edge);
        if (n3 == -1) {
            return null;
        }
        edge = (Edge)vector.elementAt(n3);
        Object object4 = edge.getCost();
        vector.removeElementAt(n3);
        this.edgeList.remove(edge);
        this.fireEdgeRemoved(this, edge);
        return object4;
    }

    public void addEdge(Object object, Object object2, Object object3) {
        this.addEdge(new Edge(object, object2, object3));
    }

    public void addEdge(Edge edge) {
        int n;
        Object object = edge.getSourceValue();
        Object object2 = edge.getDestinationValue();
        if (!this.nodeList.contains(object)) {
            throw new RuntimeException("Node " + object + " not in graph!");
        }
        if (!this.nodeList.contains(object2)) {
            throw new RuntimeException("Node " + object2 + " not in graph!");
        }
        Vector vector = this.getEdgesFromTo(edge.getSourceValue(), edge.getDestinationValue());
        for (n = 0; n < vector.size(); ++n) {
            if (!((Edge)vector.get(n)).getCost().equals(edge.getCost())) continue;
            throw new RuntimeException("That edge is already in the graph!");
        }
        vector = null;
        n = this.findNodeIndexByValue(object);
        int n2 = this.findNodeIndexByValue(object2);
        this.edgeList.add(edge);
        vector = n < n2 ? (Vector)this.transitionMatrix.get(n2, n) : (Vector)this.transitionMatrix.get(n, n2);
        vector.add(edge);
        this.fireEdgeAdded(this, edge);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        Object e;
        int n;
        String string = "";
        string = string + "Nodes:\n";
        for (n = 0; n < this.nodeList.size(); ++n) {
            e = this.nodeList.get(n);
            if (e == null) continue;
            string = string + e.toString() + "\n";
        }
        string = string + "\n";
        string = string + "Edges:\n";
        for (n = 0; n < this.edgeList.size(); ++n) {
            e = this.edgeList.get(n);
            if (e == null) continue;
            string = string + e.toString() + "\n";
        }
        return string;
    }
}

