/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Constant;
import beowulf.model.math.function.Difference;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.Quotient;
import beowulf.model.math.function.SquareRoot;
import beowulf.model.math.function.UnaryFunction;

public final class ArcSine
extends UnaryFunction {
    private static final long serialVersionUID = 3257572789048129072L;

    public ArcSine() {
    }

    public ArcSine(Function function) {
        super(function);
    }

    public double evaluate(double d) {
        return Math.asin(this.f.evaluate(d));
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = Product.createProduct((Function)this.f.clone(), (Function)this.f.clone());
        Function function2 = Difference.createDifference(new Constant(1.0), function);
        return Quotient.createQuotient(this.f.getDerivative(), new SquareRoot(function2));
    }

    public Object clone() {
        if (this.f == null) {
            return new ArcSine();
        }
        return new ArcSine((Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "asin(x)" : "asin(" + this.f + ")";
    }
}

