/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.UnaryFunction;

public final class Exponential
extends UnaryFunction {
    private static final long serialVersionUID = 3257572793326776632L;

    public Exponential() {
    }

    public Exponential(Function function) {
        super(function);
    }

    public double evaluate(double d) {
        return Math.exp(this.f.evaluate(d));
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        return Product.createProduct(new Exponential((Function)this.f.clone()), this.f.getDerivative());
    }

    public Object clone() {
        if (this.f == null) {
            return new Exponential();
        }
        return new Exponential((Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "exp(x)" : "exp(" + this.f + ")";
    }
}

