/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Function;
import java.util.Vector;

public abstract class Kernel {
    public double convolve(Function function, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        int n = (int)Math.ceil(d / d2 - this.getRadius());
        int n2 = (int)Math.floor(d / d2 + this.getRadius());
        for (int i = n; i <= n2; ++i) {
            double d5 = (double)i * d2;
            double d6 = d5 - d;
            d3 += this.getWeight(d6, d2) * function.evaluate(d5);
            d4 += this.getWeight(d6, d2);
            bl = false;
        }
        if (bl || d4 == 0.0) {
            throw new RuntimeException("Empty under support");
        }
        return d3 / d4;
    }

    public double convolve(Vector vector, Vector vector2, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        for (int i = 0; i < vector.size(); ++i) {
            double d5 = (Double)vector.get(i) - d;
            if (!(Math.abs(d5) < d2 * this.getRadius())) continue;
            d3 += this.getWeight(d5, d2) * (Double)vector2.get(i);
            d4 += this.getWeight(d5, d2);
            bl = false;
        }
        if (bl || d4 == 0.0) {
            throw new RuntimeException("Empty under support");
        }
        return d3 / d4;
    }

    public double getWeight(double d, double d2) {
        return this.getWeight(d / d2) / d2;
    }

    public abstract double getWeight(double var1);

    public abstract double getRadius();
}

