/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Constant;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.UnaryFunction;

public final class Power
extends UnaryFunction {
    private static final long serialVersionUID = 4051325647743956537L;
    protected double power = 1.0;

    public Power() {
    }

    public Power(double d) {
        this.power = d;
    }

    public Power(double d, Function function) {
        super(function);
        this.power = d;
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double d) {
        this.power = d;
    }

    public double evaluate(double d) {
        return Math.pow(this.f.evaluate(d), this.power);
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = this.power == 1.0 ? new Constant(1.0) : new Power(this.power - 1.0, (Function)this.f.clone());
        return Product.createProduct(Product.createProduct(new Constant(this.power), function), this.f.getDerivative());
    }

    public Object clone() {
        if (this.f == null) {
            return new Power(this.power);
        }
        return new Power(this.power, (Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "x^" + Double.toString(this.power) : "(" + this.f + ")^" + Double.toString(this.power);
    }
}

