/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.BinaryFunction;
import beowulf.model.math.function.Constant;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Sum;

public final class Product
extends BinaryFunction {
    private static final long serialVersionUID = 3258135734639932210L;

    public static Function createProduct(Function function, Function function2) {
        if (Product.isAdditiveIdentity(function) || Product.isAdditiveIdentity(function2)) {
            return new Constant(0.0);
        }
        if (Product.isMultiplicativeIdentity(function)) {
            return function2;
        }
        if (Product.isMultiplicativeIdentity(function2)) {
            return function;
        }
        return new Product(function, function2);
    }

    public Product() {
    }

    public Product(Function function, Function function2) {
        super(function, function2);
    }

    public double evaluate(double d) {
        return this.f1.evaluate(d) * this.f2.evaluate(d);
    }

    public boolean isDifferentiable() {
        return this.f1.isDifferentiable() && this.f2.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = (Function)this.f1.clone();
        Function function2 = this.f2.getDerivative();
        Function function3 = this.f1.getDerivative();
        Function function4 = (Function)this.f2.clone();
        Function function5 = Product.createProduct(function, function2);
        Function function6 = Product.createProduct(function3, function4);
        return Sum.createSum(function5, function6);
    }

    public Object clone() {
        return new Product((Function)this.f1.clone(), (Function)this.f2.clone());
    }

    public String toString() {
        return "(" + this.f1 + " * " + this.f2 + ")";
    }
}

