/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Function;
import beowulf.model.math.function.Kernel;
import java.util.Vector;

public class SampledFunction
extends Function {
    private static final long serialVersionUID = 3256722870754555959L;
    public static final Kernel BOX = new Kernel(){

        public double getRadius() {
            return 0.5;
        }

        public double getWeight(double d) {
            if (-0.5 <= d && d < 0.5) {
                return 1.0;
            }
            return 0.0;
        }
    };
    public static final Kernel LINEAR = new Kernel(){

        public double getRadius() {
            return 1.0;
        }

        public double getWeight(double d) {
            if (Math.abs(d) >= 1.0) {
                return 0.0;
            }
            return 1.0 - Math.abs(d);
        }
    };
    public static final Kernel QUADRATIC = new Kernel(){

        public double getRadius() {
            return 1.5;
        }

        public double getWeight(double d) {
            if (Math.abs(d) <= 0.5) {
                return 0.75 - d * d;
            }
            if (Math.abs(d) <= 1.5) {
                return 0.5 * d * d - 1.5 * Math.abs(d) + 1.125;
            }
            return 0.0;
        }
    };
    public static final Kernel GAUSS = new Kernel(){

        public double getRadius() {
            return 25.0;
        }

        public double getWeight(double d) {
            return Math.exp(-d * d / 2.0) / Math.sqrt(Math.PI * 2);
        }
    };
    public static final Kernel SINC = new Kernel(){

        public double getRadius() {
            return 25.0;
        }

        public double getWeight(double d) {
            if (d == 0.0) {
                return 1.0;
            }
            return Math.sin(Math.PI * d) / d;
        }
    };
    protected static final Kernel DEFAULT_KERNEL = LINEAR;
    protected Vector sampleLocations = new Vector();
    protected Vector sampleValues = new Vector();
    protected Function f;
    protected double spacing;
    protected Kernel kernel;

    public SampledFunction(Function function, double d) {
        this(function, d, DEFAULT_KERNEL);
    }

    public SampledFunction(Vector vector, Vector vector2, double d) {
        this(vector, vector2, d, DEFAULT_KERNEL);
    }

    public SampledFunction(Function function, double d, Kernel kernel) {
        this.f = function;
        this.spacing = d;
        this.kernel = kernel;
    }

    public SampledFunction(Vector vector, Vector vector2, double d, Kernel kernel) {
        this.kernel = kernel;
        this.spacing = d;
        this.sampleLocations.addAll(vector);
        this.sampleValues.addAll(vector2);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public double evaluate(double d) {
        if (this.f == null) {
            return this.kernel.convolve(this.sampleLocations, this.sampleValues, d, this.spacing);
        }
        return this.kernel.convolve(this.f, d, this.spacing);
    }

    public Function getSubFunction(int n) {
        throw new RuntimeException("Sampled functions have no sub functions");
    }

    public void setSubFunction(Function function, int n) {
        throw new RuntimeException("Sampled functions have no sub functions");
    }

    public int getSubFunctionCount() {
        return 0;
    }
}

