/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Constant;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.Quotient;
import beowulf.model.math.function.UnaryFunction;

public final class SquareRoot
extends UnaryFunction {
    private static final long serialVersionUID = 3545231453362140983L;

    public SquareRoot() {
    }

    public SquareRoot(Function function) {
        super(function);
    }

    public double evaluate(double d) {
        return Math.sqrt(this.f.evaluate(d));
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = Product.createProduct(new Constant(2.0), new SquareRoot((Function)this.f.clone()));
        return Quotient.createQuotient(this.f.getDerivative(), function);
    }

    public Object clone() {
        if (this.f == null) {
            return new SquareRoot();
        }
        return new SquareRoot((Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "sqrt(x)" : "sqrt(" + this.f + ")";
    }
}

