/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Cosine;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.Quotient;
import beowulf.model.math.function.UnaryFunction;

public final class Tangent
extends UnaryFunction {
    private static final long serialVersionUID = 3257291322510423859L;

    public Tangent() {
    }

    public Tangent(Function function) {
        super(function);
    }

    public double evaluate(double d) {
        return Math.tan(this.f.evaluate(d));
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = Product.createProduct(new Cosine((Function)this.f.clone()), new Cosine((Function)this.f.clone()));
        return new Quotient(this.f.getDerivative(), function);
    }

    public Object clone() {
        if (this.f == null) {
            return new Tangent();
        }
        return new Tangent((Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "tan(x)" : "tan(" + this.f + ")";
    }
}

