/*
 * Decompiled with CFR 0.152.
 */
package beowulf.util;

import java.awt.image.BufferedImage;

public class SimpleImage {
    private int[] data;
    private int width;
    private int height;

    public SimpleImage() {
        this.data = new int[0];
    }

    public SimpleImage(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.ensureSize();
    }

    public void setSize(SimpleImage simpleImage) {
        this.setSize(simpleImage.width, simpleImage.height);
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.ensureSize();
    }

    public void set(SimpleImage simpleImage) {
        this.setSize(simpleImage);
        System.arraycopy(simpleImage.data, 0, this.data, 0, this.height * this.width);
    }

    public void set(BufferedImage bufferedImage) {
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.ensureSize();
        bufferedImage.getRGB(0, 0, this.width, this.height, this.data, 0, this.width);
    }

    public void set(int n, int n2, int n3) {
        this.data[n2 * this.width + n] = n3;
    }

    public int get(int n, int n2) {
        return this.data[n2 * this.width + n];
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void tightenSpace() {
        if (this.data != null && this.data.length > this.height * this.width) {
            int[] nArray = new int[this.height * this.width];
            System.arraycopy(this.data, 0, nArray, 0, this.height * this.width);
            this.data = nArray;
        }
    }

    public void ensureSize() {
        if (this.data == null || this.data.length < this.height * this.width) {
            int[] nArray = new int[this.height * this.width];
            System.arraycopy(this.data, 0, nArray, 0, this.height * this.width);
            this.data = nArray;
        }
    }

    public void difference(SimpleImage simpleImage, SimpleImage simpleImage2) {
        SimpleImage simpleImage3 = this;
        if (simpleImage3.getHeight() != simpleImage.getHeight() || simpleImage3.getWidth() != simpleImage.getWidth()) {
            return;
        }
        simpleImage2.setSize(simpleImage3.getWidth(), simpleImage3.getHeight());
        for (int i = 0; i < simpleImage3.height; ++i) {
            for (int j = 0; j < simpleImage3.width; ++j) {
                int n = simpleImage3.get(j, i);
                int n2 = simpleImage.get(j, i);
                int n3 = n >> 16 & 0xFF;
                int n4 = n >> 8 & 0xFF;
                int n5 = n >> 0 & 0xFF;
                int n6 = n2 >> 16 & 0xFF;
                int n7 = n2 >> 8 & 0xFF;
                int n8 = n2 >> 0 & 0xFF;
                int n9 = Math.abs(n3 - n6);
                int n10 = Math.abs(n4 - n7);
                int n11 = Math.abs(n5 - n8);
                simpleImage2.set(j, i, n9 << 16 | n10 << 8 | n11 << 0);
            }
        }
    }

    public SimpleImage difference(SimpleImage simpleImage) {
        SimpleImage simpleImage2 = this;
        if (simpleImage2.getHeight() != simpleImage.getHeight() || simpleImage2.getWidth() != simpleImage.getWidth()) {
            return null;
        }
        SimpleImage simpleImage3 = new SimpleImage(simpleImage2.getWidth(), simpleImage2.getHeight());
        simpleImage2.difference(simpleImage, simpleImage3);
        return simpleImage3;
    }
}

