/*
 * Decompiled with CFR 0.152.
 */
package beowulf.util.pooling;

import beowulf.util.pooling.Pool;
import java.util.Vector;

public class ReflectionPool
implements Pool {
    public static final int DEFAULT_INITIAL_COUNT = 10;
    protected Class poolClass;
    protected Vector freeObjects;

    public ReflectionPool(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this(Class.forName(string), 10);
    }

    public ReflectionPool(Class clazz) throws InstantiationException, IllegalAccessException {
        this(clazz, 10);
    }

    public ReflectionPool(Class clazz, int n) throws InstantiationException, IllegalAccessException {
        this.poolClass = clazz;
        this.freeObjects = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.freeObjects.set(i, this.poolClass.newInstance());
        }
    }

    public Class getPoolClass() {
        return this.poolClass;
    }

    public synchronized Object checkOut() {
        if (this.freeObjects.size() == 0) {
            try {
                return this.poolClass.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        Object e = this.freeObjects.lastElement();
        this.freeObjects.removeElementAt(this.freeObjects.size() - 1);
        return e;
    }

    public synchronized void checkIn(Object object) {
        this.freeObjects.insertElementAt(object, this.freeObjects.size());
    }
}

