/*
 * Decompiled with CFR 0.152.
 */
package org.trippi;

import gnu.trove.TIntObjectHashMap;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.Graph;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphElementFactoryException;
import org.jrdf.graph.GraphException;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.n3.N3Writer;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.openrdf.rio.ntriples.NTriplesWriter;
import org.openrdf.rio.rdfxml.RDFXMLParser;
import org.openrdf.rio.rdfxml.RDFXMLWriter;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.rio.turtle.TurtleWriter;
import org.trippi.RDFFormat;
import org.trippi.TrippiException;
import org.trippi.io.CountTripleWriter;
import org.trippi.io.RIOTripleIterator;
import org.trippi.io.RIOTripleWriter;
import org.trippi.io.TripleWriter;
import org.trippi.io.XMLDeclarationRemover;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TripleIterator {
    public static final RDFFormat[] INPUT_FORMATS = new RDFFormat[]{RDFFormat.N_TRIPLES, RDFFormat.RDF_XML, RDFFormat.TURTLE};
    public static final RDFFormat[] OUTPUT_FORMATS = new RDFFormat[]{RDFFormat.N_TRIPLES, RDFFormat.NOTATION_3, RDFFormat.RDF_XML, RDFFormat.TURTLE, RDFFormat.COUNT};
    private Map<String, String> m_aliases = new HashMap<String, String>();

    public abstract boolean hasNext() throws TrippiException;

    public abstract Triple next() throws TrippiException;

    public abstract void close() throws TrippiException;

    public void setAliasMap(Map<String, String> aliases) {
        this.m_aliases = aliases;
    }

    public Map<String, String> getAliasMap() {
        return new HashMap<String, String>(this.m_aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() throws TrippiException {
        try {
            int n = 0;
            while (this.hasNext()) {
                this.next();
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.close();
        }
    }

    public int toStream(OutputStream out, RDFFormat format) throws TrippiException {
        return this.toStream(out, format, true);
    }

    public int toStream(OutputStream out, RDFFormat format, boolean includeXMLDeclaration) throws TrippiException {
        TripleWriter writer;
        if (format == RDFFormat.TURTLE) {
            writer = new RIOTripleWriter((RDFWriter)new TurtleWriter(out), this.m_aliases);
        } else if (format == RDFFormat.RDF_XML) {
            OutputStream sink = includeXMLDeclaration ? out : new XMLDeclarationRemover(out);
            writer = new RIOTripleWriter((RDFWriter)new RDFXMLWriter(sink), this.m_aliases);
        } else if (format == RDFFormat.N_TRIPLES) {
            writer = new RIOTripleWriter((RDFWriter)new NTriplesWriter(out), this.m_aliases);
        } else if (format == RDFFormat.NOTATION_3) {
            writer = new RIOTripleWriter((RDFWriter)new N3Writer(out), this.m_aliases);
        } else if (format == RDFFormat.COUNT) {
            writer = new CountTripleWriter(out);
        } else {
            throw new TrippiException("Unsupported output format: " + format.getName());
        }
        return ((TripleWriter)writer).write(this);
    }

    public static TripleIterator fromStream(InputStream in, String baseURI, RDFFormat format) throws TrippiException {
        RDFXMLParser parser;
        if (baseURI == null) {
            baseURI = "http://localhost/";
        }
        if (format == RDFFormat.RDF_XML) {
            parser = new RDFXMLParser();
        } else if (format == RDFFormat.TURTLE) {
            parser = new TurtleParser();
        } else if (format == RDFFormat.N_TRIPLES) {
            parser = new NTriplesParser();
        } else {
            throw new TrippiException("Unsupported input format: " + format.getName());
        }
        return new RIOTripleIterator(in, (RDFParser)parser, baseURI);
    }

    public static TripleIterator fromStream(InputStream in, RDFFormat format) throws TrippiException {
        return TripleIterator.fromStream(in, null, format);
    }

    public void addToGraph(Graph graph) throws TrippiException {
        this.addOrDelete(graph, true);
    }

    public void deleteFromGraph(Graph graph) throws TrippiException {
        this.addOrDelete(graph, false);
    }

    private void addOrDelete(Graph graph, boolean add) throws TrippiException {
        try {
            GraphElementFactory factory = graph.getElementFactory();
            TIntObjectHashMap nodePool = new TIntObjectHashMap();
            while (this.hasNext()) {
                Triple ot = this.next();
                Node subject = TripleIterator.localize((Node)ot.getSubject(), factory, nodePool);
                Node predicate = TripleIterator.localize((Node)ot.getPredicate(), factory, nodePool);
                Node object = TripleIterator.localize((Node)ot.getObject(), factory, nodePool);
                Triple triple = factory.createTriple((SubjectNode)subject, (PredicateNode)predicate, (ObjectNode)object);
                if (add) {
                    graph.add(triple);
                    continue;
                }
                graph.remove(triple);
            }
        }
        catch (GraphException e) {
            throw new TrippiException("Unable to modify Graph using TripleIterator", e);
        }
        catch (GraphElementFactoryException e) {
            throw new TrippiException("Unable to modify Graph using TripleIterator", e);
        }
        finally {
            this.close();
        }
    }

    private static Node localize(Node node, GraphElementFactory factory, TIntObjectHashMap nodePool) throws TrippiException {
        try {
            URIReference newNode;
            if (nodePool.containsKey(node.hashCode())) {
                return (Node)nodePool.get(node.hashCode());
            }
            if (node instanceof URIReference) {
                newNode = factory.createResource(((URIReference)node).getURI(), false);
            } else if (node instanceof Literal) {
                Literal literal = (Literal)node;
                newNode = literal.getLanguage() != null ? factory.createLiteral(literal.getLexicalForm(), literal.getLanguage()) : (literal.getDatatypeURI() != null ? factory.createLiteral(literal.getLexicalForm(), literal.getDatatypeURI()) : factory.createLiteral(literal.getLexicalForm()));
            } else if (node instanceof BlankNode) {
                newNode = factory.createResource();
            } else {
                throw new TrippiException("Unrecognized node type: " + node.getClass().getName());
            }
            nodePool.put(node.hashCode(), (Object)newNode);
            return newNode;
        }
        catch (Throwable th) {
            throw new TrippiException("Unable to localize node", th);
        }
    }
}

