/*
 * Decompiled with CFR 0.152.
 */
package org.trippi;

import java.io.InputStream;
import java.util.Map;
import org.jrdf.graph.GraphElementFactory;
import org.trippi.ConnectorDescriptor;
import org.trippi.TriplestoreReader;
import org.trippi.TriplestoreWriter;
import org.trippi.TrippiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TriplestoreConnector {
    public static TriplestoreConnector init(String className, Map<String, String> configuration) throws TrippiException, ClassNotFoundException {
        TriplestoreConnector connector = TriplestoreConnector.getConnector(className);
        connector.init(configuration);
        return connector;
    }

    public static ConnectorDescriptor getDescriptor(String className) throws TrippiException {
        String path = className.replaceAll("\\.", "/") + "Descriptor.xml";
        InputStream xml = ClassLoader.getSystemClassLoader().getResourceAsStream(path);
        if (xml != null) {
            return new ConnectorDescriptor(xml);
        }
        throw new TrippiException("Not found in classpath: " + path);
    }

    private static TriplestoreConnector getConnector(String className) throws TrippiException, ClassNotFoundException {
        Class<?> connectorClass = Class.forName(className);
        try {
            return (TriplestoreConnector)connectorClass.newInstance();
        }
        catch (Exception e) {
            throw new TrippiException("Unable to get an instance of " + className, e);
        }
    }

    public abstract void init(Map<String, String> var1) throws TrippiException;

    public abstract TriplestoreReader getReader();

    public abstract TriplestoreWriter getWriter();

    public abstract GraphElementFactory getElementFactory();

    public abstract void close() throws TrippiException;

    public void finalize() throws TrippiException {
        this.close();
    }

    public static void main(String[] args) throws Exception {
        ConnectorDescriptor d = TriplestoreConnector.getDescriptor(args[0]);
        System.out.println(d.toString());
    }
}

