/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.config;

import java.util.Map;
import org.trippi.TrippiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtils {
    public static String getRequired(Map<String, String> map, String key) throws TrippiException {
        String value = map.get(key);
        if (value == null || value.length() == 0) {
            throw new TrippiException("Missing required configuration value: " + key);
        }
        return value.trim();
    }

    public static int getRequiredInt(Map<String, String> map, String key) throws TrippiException {
        try {
            return Integer.parseInt(ConfigUtils.getRequired(map, key));
        }
        catch (NumberFormatException e) {
            throw new TrippiException("Configuration value must be an integer: " + key);
        }
    }

    public static int getRequiredNNInt(Map<String, String> map, String key) throws TrippiException {
        try {
            int i = Integer.parseInt(ConfigUtils.getRequired(map, key));
            if (i < 0) {
                throw new TrippiException("Value must not be negative.");
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new TrippiException("Configuration value must be an integer: " + key);
        }
    }

    public static int getRequiredPosInt(Map<String, String> map, String key) throws TrippiException {
        try {
            int i = Integer.parseInt(ConfigUtils.getRequired(map, key));
            if (i < 1) {
                throw new TrippiException("Value must be an integer greater than 0.");
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new TrippiException("Configuration value must be an integer: " + key);
        }
    }

    public static boolean getRequiredBoolean(Map<String, String> map, String key) throws TrippiException {
        String val = ConfigUtils.getRequired(map, key);
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        throw new TrippiException("Expected boolean for " + key + ", but got " + val);
    }
}

