/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.trippi.TrippiException;
import org.trippi.config.TrippiProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrippiConfig {
    private File m_file;

    public TrippiConfig(File configFile) {
        this.m_file = configFile;
    }

    public Map<String, TrippiProfile> getProfiles() throws TrippiException {
        Properties p = this.loadProps();
        HashMap<String, TrippiProfile> profileMap = new HashMap<String, TrippiProfile>();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("profile.") || !key.endsWith(".label")) continue;
            String id = key.substring(8, key.lastIndexOf("."));
            profileMap.put(id, TrippiConfig.getProfile(p, id, p.getProperty(key)));
        }
        return profileMap;
    }

    public static Map<String, TrippiProfile> getProfiles(Properties p) {
        HashMap<String, TrippiProfile> profileMap = new HashMap<String, TrippiProfile>();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("profile.") || !key.endsWith(".label")) continue;
            String id = key.substring(8, key.lastIndexOf("."));
            profileMap.put(id, TrippiConfig.getProfile(p, id, p.getProperty(key)));
        }
        return profileMap;
    }

    public static TrippiProfile getProfile(Properties p, String id, String label) {
        String connectorClassName = null;
        String configStart = "profile." + id + ".config.";
        HashMap<String, String> config = new HashMap<String, String>();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals("profile." + id + ".connectorClassName")) {
                connectorClassName = p.getProperty(key);
                continue;
            }
            if (!key.startsWith(configStart)) continue;
            String realKey = key.substring(configStart.length());
            config.put(realKey, p.getProperty(key));
        }
        if (label == null || connectorClassName == null) {
            return null;
        }
        return new TrippiProfile(id, label, connectorClassName, config);
    }

    public void setProfiles(Map<String, TrippiProfile> profiles) throws TrippiException {
        Properties p = this.loadProps();
        TrippiConfig.clearProfiles(p);
        for (String id : profiles.keySet()) {
            TrippiConfig.putProfile(p, profiles.get(id));
        }
        this.saveProps(p);
    }

    private static void clearProfiles(Properties p) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("profile.")) continue;
            keysToRemove.add(key);
        }
        Iterator iter = keysToRemove.iterator();
        while (iter.hasNext()) {
            p.remove(iter.next());
        }
    }

    private static void putProfile(Properties p, TrippiProfile profile) {
        String s = "profile." + profile.getId() + ".";
        p.setProperty(s + "label", profile.getLabel());
        p.setProperty(s + "connectorClassName", profile.getConnectorClassName());
        s = s + "config.";
        Map<String, String> map = profile.getConfiguration();
        for (String key : map.keySet()) {
            String val = map.get(key);
            p.setProperty(s + key, val);
        }
    }

    public Map<String, String> getAliasMap() throws TrippiException {
        return TrippiConfig.getAliasMap(this.loadProps());
    }

    private static Map<String, String> getAliasMap(Properties p) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("alias.")) continue;
            map.put(key.replaceFirst("alias.", ""), p.getProperty(key));
        }
        return map;
    }

    public void setAliasMap(Map<String, String> aliasMap) throws TrippiException {
        Properties p = this.loadProps();
        TrippiConfig.clearAliases(p);
        for (String alias : aliasMap.keySet()) {
            String value = aliasMap.get(alias);
            p.setProperty("alias." + alias, value);
        }
        this.saveProps(p);
    }

    private static void clearAliases(Properties p) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("alias.")) continue;
            keysToRemove.add(key);
        }
        Iterator iter = keysToRemove.iterator();
        while (iter.hasNext()) {
            p.remove((String)iter.next());
        }
    }

    private Properties loadProps() throws TrippiException {
        try {
            Properties p = new Properties();
            if (this.m_file.exists()) {
                p.load(new FileInputStream(this.m_file));
            }
            return p;
        }
        catch (Exception e) {
            throw new TrippiException("Error loading config file", e);
        }
    }

    private void saveProps(Properties p) throws TrippiException {
        try {
            p.store(new FileOutputStream(this.m_file), null);
        }
        catch (Exception e) {
            throw new TrippiException("Error saving config file", e);
        }
    }
}

