/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.trippi.FlushErrorHandler;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TripleUpdate;
import org.trippi.TriplestoreWriter;
import org.trippi.TrippiException;
import org.trippi.impl.base.AliasManager;
import org.trippi.impl.base.ConcurrentTriplestoreReader;
import org.trippi.impl.base.TriplestoreSession;
import org.trippi.impl.base.TriplestoreSessionPool;
import org.trippi.impl.base.UpdateBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentTriplestoreWriter
extends ConcurrentTriplestoreReader
implements TriplestoreWriter,
Runnable {
    private static final Logger logger = Logger.getLogger((String)ConcurrentTriplestoreWriter.class.getName());
    private TriplestoreSessionPool m_pool;
    private UpdateBuffer m_buffer;
    private int m_autoFlushBufferSize;
    private int m_autoFlushDormantSeconds;
    private TriplestoreSession m_updateSession;
    private boolean m_needToClose = false;
    private Object m_bufferInputLock = new Object();
    private long m_lastBufferInputTime;
    private boolean m_cacheDeletes = false;

    public ConcurrentTriplestoreWriter(TriplestoreSessionPool pool, AliasManager aliasManager, TriplestoreSession updateSession, UpdateBuffer buffer, int autoFlushBufferSize, int autoFlushDormantSeconds) throws IOException, TrippiException {
        super(pool, aliasManager);
        this.m_pool = pool;
        this.m_updateSession = updateSession;
        this.m_buffer = buffer;
        this.m_autoFlushBufferSize = autoFlushBufferSize;
        this.m_autoFlushDormantSeconds = autoFlushDormantSeconds;
        this.flushBuffer();
        this.m_lastBufferInputTime = System.currentTimeMillis();
        Thread t = new Thread(this);
        t.start();
    }

    public void setCacheDeletes(boolean cacheDeletes) {
        this.m_cacheDeletes = cacheDeletes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(List<Triple> triples, boolean flush) throws IOException, TrippiException {
        boolean flushed = false;
        Object object = this.m_bufferInputLock;
        synchronized (object) {
            this.m_buffer.add(triples);
            this.m_lastBufferInputTime = System.currentTimeMillis();
            if (this.m_buffer.size() > this.m_buffer.safeCapacity()) {
                logger.info((Object)("Forcing flush: Buffer size (" + this.m_buffer.size() + ") exceeded safe capacity."));
                this.flushBuffer();
                flushed = true;
            }
        }
        if (!flushed && flush) {
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TripleIterator iter, boolean flush) throws IOException, TrippiException {
        try {
            int maxListSize = this.m_autoFlushBufferSize;
            ArrayList<Triple> triples = new ArrayList<Triple>();
            while (iter.hasNext()) {
                triples.add(iter.next());
                if (triples.size() != maxListSize) continue;
                this.add(triples, false);
                triples.clear();
            }
            if (triples.size() > 0) {
                this.add(triples, false);
                triples.clear();
            }
            if (flush) {
                this.flushBuffer();
            }
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Triple triple, boolean flush) throws IOException, TrippiException {
        boolean flushed = false;
        Object object = this.m_bufferInputLock;
        synchronized (object) {
            this.m_buffer.add(triple);
            this.m_lastBufferInputTime = System.currentTimeMillis();
            if (this.m_buffer.size() > this.m_buffer.safeCapacity()) {
                logger.info((Object)("Forcing flush: Buffer size (" + this.m_buffer.size() + ") exceeded safe capacity."));
                this.flushBuffer();
                flushed = true;
            }
        }
        if (!flushed && flush) {
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(List<Triple> triples, boolean flush) throws IOException, TrippiException {
        boolean flushed = false;
        Object object = this.m_bufferInputLock;
        synchronized (object) {
            this.m_buffer.delete(triples);
            this.m_lastBufferInputTime = System.currentTimeMillis();
            if (this.m_buffer.size() > this.m_buffer.safeCapacity()) {
                logger.info((Object)("Forcing flush: Buffer size (" + this.m_buffer.size() + ") exceeded safe capacity."));
                this.flushBuffer();
                flushed = true;
            }
        }
        if (!flushed && flush) {
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(TripleIterator iter, boolean flush) throws IOException, TrippiException {
        File tempFile = null;
        try {
            if (this.m_cacheDeletes) {
                tempFile = File.createTempFile("trippi-deltriples", "txt");
                FileOutputStream fout = new FileOutputStream(tempFile);
                try {
                    iter.toStream(fout, RDFFormat.TURTLE);
                }
                finally {
                    try {
                        fout.close();
                    }
                    catch (Exception e) {}
                }
                iter.close();
                iter = TripleIterator.fromStream(new FileInputStream(tempFile), RDFFormat.TURTLE);
            }
            try {
                int maxListSize = this.m_autoFlushBufferSize;
                ArrayList<Triple> triples = new ArrayList<Triple>();
                while (iter.hasNext()) {
                    triples.add(iter.next());
                    if (triples.size() != maxListSize) continue;
                    this.delete(triples, false);
                    triples.clear();
                }
                if (triples.size() > 0) {
                    this.delete(triples, false);
                    triples.clear();
                }
                if (flush) {
                    this.flushBuffer();
                }
            }
            finally {
                iter.close();
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Triple triple, boolean flush) throws IOException, TrippiException {
        boolean flushed = false;
        Object object = this.m_bufferInputLock;
        synchronized (object) {
            this.m_buffer.delete(triple);
            this.m_lastBufferInputTime = System.currentTimeMillis();
            if (this.m_buffer.size() > this.m_buffer.safeCapacity()) {
                logger.info((Object)("Forcing flush: Buffer size (" + this.m_buffer.size() + ") exceeded safe capacity."));
                this.flushBuffer();
                flushed = true;
            }
        }
        if (!flushed && flush) {
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushBuffer() throws IOException, TrippiException {
        long start = System.currentTimeMillis();
        int size = 0;
        TriplestoreSession triplestoreSession = this.m_updateSession;
        synchronized (triplestoreSession) {
            size = this.m_buffer.size();
            this.m_buffer.flush(this.m_updateSession);
        }
        long end = System.currentTimeMillis();
        double sec = (double)(end - start) / 1000.0;
        logger.info((Object)("Flushed " + size + " updates in " + sec + "seconds."));
    }

    @Override
    public void setFlushErrorHandler(FlushErrorHandler h) {
        this.m_buffer.setFlushErrorHandler(h);
    }

    @Override
    public int getBufferSize() {
        return this.m_buffer.size();
    }

    @Override
    public void run() {
        while (!this.m_needToClose) {
            long now = System.currentTimeMillis();
            long secondsSinceLast = (now - this.m_lastBufferInputTime) / 1000L;
            if (this.m_buffer.size() > 0 && (secondsSinceLast >= (long)this.m_autoFlushDormantSeconds || this.m_buffer.size() >= this.m_autoFlushBufferSize)) {
                try {
                    logger.info((Object)("Auto-flushing update buffer.  (" + secondsSinceLast + "sec., size = " + this.m_buffer.size() + ")"));
                    this.flushBuffer();
                }
                catch (Exception e) {
                    String msg = e.getClass().getName();
                    if (e.getMessage() != null) {
                        msg = msg + ": " + e.getMessage();
                    }
                    logger.warn((Object)("Error auto-flushing update buffer: " + msg), (Throwable)e);
                }
            }
            if (this.m_needToClose) continue;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
    }

    @Override
    public synchronized void close() throws TrippiException {
        if (!this.m_needToClose) {
            String msg;
            logger.info((Object)"Closing...");
            this.m_needToClose = true;
            try {
                this.flushBuffer();
            }
            catch (Exception e) {
                msg = e.getClass().getName();
                if (e.getMessage() != null) {
                    msg = msg + ": " + e.getMessage();
                }
                logger.warn((Object)("Error flushing update buffer while closing Triplestore: " + msg));
            }
            try {
                this.m_buffer.close();
            }
            catch (Exception e) {
                msg = e.getClass().getName();
                if (e.getMessage() != null) {
                    msg = msg + ": " + e.getMessage();
                }
                logger.warn((Object)("Error closing update buffer while closing Triplestore: " + msg));
            }
            this.m_pool.close();
        }
    }

    @Override
    public List<TripleUpdate> findBufferedUpdates(SubjectNode subject, PredicateNode predicate, ObjectNode object, int updateType) {
        return this.m_buffer.findBufferedUpdates(subject, predicate, object, updateType);
    }
}

