/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import gnu.trove.TIntHashSet;
import org.jrdf.graph.Triple;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;

public class DistinctTripleIterator
extends TripleIterator {
    private TripleIterator m_wrapped;
    private TIntHashSet m_seen;
    private Triple m_next;
    private boolean m_closed = false;

    public DistinctTripleIterator(TripleIterator wrapped) throws TrippiException {
        this.m_wrapped = wrapped;
        this.m_seen = new TIntHashSet();
        this.m_next = this.getNext();
    }

    private Triple getNext() throws TrippiException {
        while (this.m_wrapped.hasNext()) {
            Triple nextTriple = this.m_wrapped.next();
            if (this.seen(nextTriple.hashCode())) continue;
            return nextTriple;
        }
        return null;
    }

    private boolean seen(int id) {
        if (this.m_seen.contains(id)) {
            return true;
        }
        this.m_seen.add(id);
        return false;
    }

    public boolean hasNext() {
        return this.m_next != null;
    }

    public Triple next() throws TrippiException {
        if (this.m_next == null) {
            return null;
        }
        Triple last = this.m_next;
        this.m_next = this.getNext();
        return last;
    }

    public void close() throws TrippiException {
        if (!this.m_closed) {
            this.m_wrapped.close();
            this.m_closed = true;
        }
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

