/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import org.jrdf.graph.Triple;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;

public class LimitedTripleIterator
extends TripleIterator {
    private TripleIterator m_wrapped;
    private int m_count;
    private int m_limit;
    private Triple m_next;
    private boolean m_closed = false;

    public LimitedTripleIterator(TripleIterator wrapped, int limit) throws TrippiException {
        this.m_wrapped = wrapped;
        this.m_count = 0;
        this.m_limit = limit;
        this.m_next = this.getNext();
    }

    private Triple getNext() throws TrippiException {
        if (this.m_wrapped.hasNext() && this.m_count < this.m_limit) {
            ++this.m_count;
            return this.m_wrapped.next();
        }
        return null;
    }

    public boolean hasNext() {
        return this.m_next != null;
    }

    public Triple next() throws TrippiException {
        if (this.m_next == null) {
            return null;
        }
        Triple last = this.m_next;
        this.m_next = this.getNext();
        return last;
    }

    public void close() throws TrippiException {
        if (!this.m_closed) {
            this.m_wrapped.close();
            this.m_closed = true;
        }
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

