/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.util.List;
import java.util.Map;
import org.jrdf.graph.Node;
import org.jrdf.graph.Triple;
import org.trippi.TriplePattern;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.impl.base.TriplestoreSession;
import org.trippi.impl.base.TriplestoreSessionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolAwareTupleIterator
extends TupleIterator {
    private TupleIterator m_iter;
    private TriplestoreSession m_session;
    private TriplestoreSessionPool m_pool;
    private boolean m_closed = false;

    public PoolAwareTupleIterator(TupleIterator iter, TriplestoreSession session, TriplestoreSessionPool pool) {
        this.m_iter = iter;
        this.m_session = session;
        this.m_pool = pool;
    }

    @Override
    public boolean hasNext() throws TrippiException {
        boolean has = this.m_iter.hasNext();
        if (!has) {
            this.close();
        }
        return has;
    }

    @Override
    public Map<String, Node> next() throws TrippiException {
        return this.m_iter.next();
    }

    @Override
    public List<Triple> nextTriples(TriplePattern[] patterns) throws TrippiException {
        return this.m_iter.nextTriples(patterns);
    }

    @Override
    public String[] names() throws TrippiException {
        return this.m_iter.names();
    }

    @Override
    public void close() throws TrippiException {
        if (!this.m_closed) {
            try {
                this.m_iter.close();
            }
            catch (TrippiException e) {
                throw e;
            }
            finally {
                this.m_pool.release(this.m_session);
                this.m_closed = true;
            }
        }
    }

    @Override
    public void finalize() throws TrippiException {
        this.close();
    }
}

