/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jrdf.graph.Triple;
import org.trippi.TripleIterator;
import org.trippi.TriplePattern;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

public class TupleBasedTripleIterator
extends TripleIterator {
    private static final Logger logger = Logger.getLogger((String)TupleBasedTripleIterator.class.getName());
    private TupleIterator m_tuples;
    private TriplePattern[] m_patterns;
    private boolean m_closed;
    private Triple m_next;
    private List<Triple> m_triplesFromTuples;

    public TupleBasedTripleIterator(TupleIterator tuples, TriplePattern[] patterns) throws TrippiException {
        this.m_tuples = tuples;
        this.m_patterns = patterns;
        this.m_closed = false;
        this.m_triplesFromTuples = new ArrayList<Triple>();
        try {
            this.m_next = this.getNext();
        }
        catch (TrippiException e) {
            this.close();
            throw e;
        }
    }

    private Triple getNext() throws TrippiException {
        while (this.m_triplesFromTuples.size() == 0) {
            if (!this.m_tuples.hasNext()) {
                return null;
            }
            this.m_triplesFromTuples = this.m_tuples.nextTriples(this.m_patterns);
        }
        return this.m_triplesFromTuples.remove(0);
    }

    public boolean hasNext() {
        return this.m_next != null;
    }

    public Triple next() throws TrippiException {
        if (this.m_next == null) {
            return null;
        }
        Triple last = this.m_next;
        this.m_next = this.getNext();
        return last;
    }

    public void close() throws TrippiException {
        if (!this.m_closed) {
            this.m_tuples.close();
            this.m_closed = true;
        }
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

