/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.multi;

import java.util.Map;
import org.jrdf.graph.GraphElementFactory;
import org.trippi.RDFUtil;
import org.trippi.TriplestoreConnector;
import org.trippi.TriplestoreReader;
import org.trippi.TriplestoreWriter;
import org.trippi.TrippiException;
import org.trippi.impl.multi.MultiTriplestoreWriter;

public class MultiConnector
extends TriplestoreConnector {
    private TriplestoreConnector[] m_connectors;
    private MultiTriplestoreWriter m_multiWriter;
    private GraphElementFactory m_elementFactory;

    public MultiConnector() {
    }

    public MultiConnector(TriplestoreConnector[] connectors) {
        this.m_connectors = connectors;
        TriplestoreWriter[] writers = new TriplestoreWriter[connectors.length];
        for (int i = 0; i < connectors.length; ++i) {
            writers[i] = connectors[i].getWriter();
        }
        this.m_multiWriter = new MultiTriplestoreWriter(this.m_connectors[0].getReader(), writers);
        this.m_elementFactory = new RDFUtil();
    }

    public void init(Map config) throws TrippiException {
        throw new TrippiException("This connector cannot be initialized via init()");
    }

    public TriplestoreReader getReader() {
        return this.m_connectors[0].getReader();
    }

    public TriplestoreWriter getWriter() {
        return this.m_multiWriter;
    }

    public GraphElementFactory getElementFactory() {
        return this.m_elementFactory;
    }

    public void close() throws TrippiException {
        TrippiException m_exception = null;
        for (int i = 0; i < this.m_connectors.length; ++i) {
            try {
                this.m_connectors[i].close();
                continue;
            }
            catch (TrippiException e) {
                m_exception = e;
            }
        }
        if (m_exception != null) {
            throw m_exception;
        }
    }
}

