/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.io;

import java.util.Map;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.Literal;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;
import org.trippi.io.TripleWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RIOTripleWriter
extends TripleWriter {
    private RDFWriter m_writer;
    private ValueFactoryImpl m_rioFactory = new ValueFactoryImpl();

    public RIOTripleWriter(RDFWriter writer, Map<String, String> aliases) throws TrippiException {
        try {
            this.m_writer = writer;
            for (String prefix : aliases.keySet()) {
                String name = aliases.get(prefix);
                this.m_writer.handleNamespace(prefix, name);
            }
        }
        catch (RDFHandlerException e) {
            throw new TrippiException("Error setting up RIOTripleWriter", e);
        }
    }

    @Override
    public int write(TripleIterator iter) throws TrippiException {
        try {
            this.m_writer.startRDF();
            int count = 0;
            while (iter.hasNext()) {
                Triple triple = iter.next();
                this.m_writer.handleStatement((Statement)new StatementImpl(this.rioResource(triple.getSubject()), this.rioURI(triple.getPredicate()), this.rioValue(triple.getObject())));
                ++count;
            }
            this.m_writer.endRDF();
            iter.close();
            return count;
        }
        catch (RDFHandlerException e) {
            throw new TrippiException("Error setting up RIOTripleWriter", e);
        }
    }

    private Resource rioResource(SubjectNode s) {
        if (s instanceof BlankNode) {
            return this.m_rioFactory.createBNode("" + s.hashCode());
        }
        return this.m_rioFactory.createURI(((URIReference)s).getURI().toString());
    }

    private URI rioURI(PredicateNode p) {
        return this.m_rioFactory.createURI(((URIReference)p).getURI().toString());
    }

    private Value rioValue(ObjectNode o) {
        if (o instanceof BlankNode) {
            return this.m_rioFactory.createBNode("" + o.hashCode());
        }
        if (o instanceof Literal) {
            Literal l = (Literal)o;
            if (l.getDatatypeURI() != null) {
                return this.m_rioFactory.createLiteral(l.getLexicalForm(), this.m_rioFactory.createURI(l.getDatatypeURI().toString()));
            }
            if (l.getLanguage() != null && !l.getLanguage().equals("")) {
                return this.m_rioFactory.createLiteral(l.getLexicalForm(), l.getLanguage());
            }
            return this.m_rioFactory.createLiteral(l.getLexicalForm());
        }
        return this.m_rioFactory.createURI(((URIReference)o).getURI().toString());
    }
}

