/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XMLDeclarationRemover
extends FilterOutputStream {
    private boolean m_buffering = true;
    private int m_ltCount;

    public XMLDeclarationRemover(OutputStream sink) {
        super(sink);
    }

    public void write(int b) throws IOException {
        if (this.m_buffering) {
            this.buffer((char)b);
        } else {
            super.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        if (this.m_buffering) {
            for (int i = 0; i < b.length; ++i) {
                this.buffer((char)b[i]);
            }
        } else {
            super.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.m_buffering) {
            for (int i = off; i < off + len; ++i) {
                this.buffer((char)b[i]);
            }
        } else {
            super.write(b, off, len);
        }
    }

    private void buffer(char c) throws IOException {
        if (this.m_buffering) {
            if (c == '<') {
                ++this.m_ltCount;
                if (this.m_ltCount == 2) {
                    this.m_buffering = false;
                    this.write(c);
                }
            }
        } else {
            this.write(c);
        }
    }
}

