/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.nodegraph.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.jrdf.graph.Graph;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphException;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.TripleFactory;
import org.jrdf.util.ClosableIterator;
import org.trippi.nodegraph.NodeGraph;
import org.trippi.nodegraph.NodeResults;
import org.trippi.nodegraph.TripleResults;
import org.trippi.nodegraph.impl.EmptyClosableIterator;
import org.trippi.nodegraph.impl.NodeIterator;
import org.trippi.nodegraph.impl.NodeResultsImpl;
import org.trippi.nodegraph.impl.TripleResultsImpl;

public class NodeGraphImpl
extends NodeGraph {
    private static final long serialVersionUID = 1L;
    private Graph _graph;

    public NodeGraphImpl(Graph graph) {
        this._graph = graph;
    }

    public NodeResults findSubjects(Node p, Node o) throws GraphException {
        if ((p == null || p instanceof PredicateNode) && (o == null || o instanceof ObjectNode)) {
            return new NodeResultsImpl(new NodeIterator(this.find(null, (PredicateNode)p, (ObjectNode)o), 0, p != null && o != null));
        }
        return new NodeResultsImpl(EmptyClosableIterator.INSTANCE);
    }

    public NodeResults findPredicates(Node s, Node o) throws GraphException {
        if ((s == null || s instanceof SubjectNode) && (o == null || o instanceof ObjectNode)) {
            return new NodeResultsImpl(new NodeIterator(this.find((SubjectNode)s, null, (ObjectNode)o), 1, s != null && o != null));
        }
        return new NodeResultsImpl(EmptyClosableIterator.INSTANCE);
    }

    public NodeResults findObjects(Node s, Node p) throws GraphException {
        if ((s == null || s instanceof SubjectNode) && (p == null || p instanceof PredicateNode)) {
            return new NodeResultsImpl(new NodeIterator(this.find((SubjectNode)s, (PredicateNode)p, null), 2, s != null && p != null));
        }
        return new NodeResultsImpl(EmptyClosableIterator.INSTANCE);
    }

    public TripleResults findTriples(Node s, Node p, Node o) throws GraphException {
        if (!(s != null && !(s instanceof SubjectNode) || p != null && !(p instanceof PredicateNode) || o != null && !(o instanceof ObjectNode))) {
            return new TripleResultsImpl(this.find((SubjectNode)s, (PredicateNode)p, (ObjectNode)o));
        }
        return new TripleResultsImpl(EmptyClosableIterator.INSTANCE);
    }

    public boolean contains(SubjectNode subject, PredicateNode predicate, ObjectNode object) throws GraphException {
        return this._graph.contains(subject, predicate, object);
    }

    public boolean contains(Triple triple) throws GraphException {
        return this._graph.contains(triple);
    }

    public ClosableIterator find(SubjectNode subject, PredicateNode predicate, ObjectNode object) throws GraphException {
        return this._graph.find(subject, predicate, object);
    }

    public ClosableIterator find(Triple triple) throws GraphException {
        return this._graph.find(triple);
    }

    public void add(SubjectNode subject, PredicateNode predicate, ObjectNode object) throws GraphException {
        this._graph.add(subject, predicate, object);
    }

    public void add(Triple triple) throws GraphException {
        this._graph.add(triple);
    }

    public void add(Iterator triples) throws GraphException {
        this._graph.add(triples);
    }

    public void remove(SubjectNode subject, PredicateNode predicate, ObjectNode object) throws GraphException {
        this._graph.remove(subject, predicate, object);
    }

    public void remove(Triple triple) throws GraphException {
        this._graph.remove(triple);
    }

    public void remove(Iterator triples) throws GraphException {
        this._graph.remove(triples);
    }

    public GraphElementFactory getElementFactory() {
        return this._graph.getElementFactory();
    }

    public TripleFactory getTripleFactory() {
        return this._graph.getTripleFactory();
    }

    public long getNumberOfTriples() throws GraphException {
        return this._graph.getNumberOfTriples();
    }

    public boolean isEmpty() throws GraphException {
        return this._graph.isEmpty();
    }

    public void close() {
        try {
            Method closeMethod = this._graph.getClass().getMethod("close", new Class[0]);
            closeMethod.invoke((Object)this._graph, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable u = e.getCause();
            if (u instanceof RuntimeException) {
                throw (RuntimeException)u;
            }
            throw new RuntimeException("Unexpected checked exception encountered while reflectively invoking graph.close()", u);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

