/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.server.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TriplestoreConnector;
import org.trippi.TriplestoreReader;
import org.trippi.TriplestoreWriter;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.config.TrippiConfig;
import org.trippi.config.TrippiProfile;
import org.trippi.server.TrippiServer;
import org.trippi.server.http.Styler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrippiServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private TriplestoreConnector m_connector;
    private TrippiServer m_server;
    private Map<TrippiProfile, TriplestoreConnector> m_connectors;
    private Map<String, TrippiServer> m_servers;
    private Styler m_styler;

    public TriplestoreReader getReader() throws ServletException {
        return null;
    }

    public TriplestoreWriter getWriter() throws ServletException {
        return null;
    }

    public TriplestoreConnector getConnector() throws ServletException {
        String profileId = this.getInitParameter("profileId");
        if (profileId == null) {
            return null;
        }
        String configFile = this.getInitParameter("configFile");
        if (configFile != null && !configFile.equals("")) {
            try {
                TrippiConfig config = new TrippiConfig(new File(configFile));
                TrippiProfile profile = config.getProfiles().get(profileId);
                if (profile != null) {
                    TriplestoreConnector conn = profile.getConnector();
                    conn.getReader().setAliasMap(config.getAliasMap());
                    return conn;
                }
                throw new TrippiException("No such profile: " + profileId);
            }
            catch (Exception e) {
                throw new ServletException("Error initializing in single-server mode.", (Throwable)e);
            }
        }
        throw new ServletException("configFile initialization parameter missing.");
    }

    private Map<TrippiProfile, TriplestoreConnector> getConnectors() throws ServletException {
        String configFile = this.getInitParameter("configFile");
        if (configFile != null && !configFile.equals("")) {
            HashMap<TrippiProfile, TriplestoreConnector> connectors = new HashMap<TrippiProfile, TriplestoreConnector>();
            try {
                TrippiConfig config = new TrippiConfig(new File(configFile));
                Map<String, TrippiProfile> profiles = config.getProfiles();
                Iterator<String> iter = profiles.keySet().iterator();
                while (iter.hasNext()) {
                    TrippiProfile profile = profiles.get(iter.next());
                    TriplestoreConnector conn = profile.getConnector();
                    conn.getReader().setAliasMap(config.getAliasMap());
                    connectors.put(profile, conn);
                }
                return connectors;
            }
            catch (Exception e) {
                for (TrippiProfile profile : connectors.keySet()) {
                    TriplestoreConnector conn = (TriplestoreConnector)connectors.get(profile);
                    try {
                        conn.close();
                    }
                    catch (TrippiException e2) {
                        this.log("Error closing connector", e2);
                    }
                }
                throw new ServletException("Error initializing in multi-server mode.", (Throwable)e);
            }
        }
        throw new ServletException("configFile initialization parameter missing.");
    }

    public boolean closeOnDestroy() {
        return true;
    }

    public String getContext(String origContext) {
        return origContext;
    }

    public String getErrorStylesheetLocation() {
        return this.getInitParameter("errorStylesheetLocation");
    }

    public String getIndexStylesheetLocation() {
        return this.getInitParameter("indexStylesheetLocation");
    }

    public String getFormStylesheetLocation() {
        return this.getInitParameter("formStylesheetLocation");
    }

    private String getPath(String loc) {
        if (loc == null) {
            return null;
        }
        if (loc.startsWith("/")) {
            String foo = this.getServletContext().getRealPath("/foo");
            File dir = new File(foo).getParentFile().getParentFile();
            File file = new File(dir, loc);
            return file.toString();
        }
        return this.getServletContext().getRealPath(loc);
    }

    public final void init() throws ServletException {
        try {
            String indexStylesheetPath = this.getPath(this.getIndexStylesheetLocation());
            String formStylesheetPath = this.getPath(this.getFormStylesheetLocation());
            String errorStylesheetPath = this.getPath(this.getErrorStylesheetLocation());
            this.m_styler = new Styler(indexStylesheetPath, formStylesheetPath, errorStylesheetPath);
        }
        catch (Exception e) {
            throw new ServletException("Error loading stylesheet(s)", (Throwable)e);
        }
        TriplestoreWriter writer = this.getWriter();
        if (writer != null) {
            this.m_server = new TrippiServer(writer);
            return;
        }
        TriplestoreReader reader = this.getReader();
        if (reader != null) {
            this.m_server = new TrippiServer(reader);
            return;
        }
        this.m_connector = this.getConnector();
        if (this.m_connector != null) {
            this.m_server = new TrippiServer(this.m_connector);
        } else {
            this.m_connectors = this.getConnectors();
            this.m_servers = new HashMap<String, TrippiServer>();
            for (TrippiProfile profile : this.m_connectors.keySet()) {
                TriplestoreConnector conn = this.m_connectors.get(profile);
                this.m_servers.put(profile.getId(), new TrippiServer(conn));
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        try {
            String profileId = request.getPathInfo();
            if (profileId != null) {
                profileId = profileId.replaceAll("/", "");
            }
            if (profileId == null || profileId.equals("")) {
                if (this.m_server != null) {
                    this.doGet(this.m_server, request, response);
                } else {
                    response.setContentType("text/html; charset=UTF-8");
                    this.doIndex(new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")), request.getRequestURL().toString(), request.getContextPath());
                }
            } else {
                if (this.m_server != null) {
                    throw new ServletException("Not in multi-server mode.");
                }
                this.doGet(this.m_servers.get(profileId), request, response);
            }
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable th) {
            try {
                response.setContentType("text/html; charset=UTF-8");
                response.setStatus(500);
                StringWriter sWriter = new StringWriter();
                PrintWriter out = new PrintWriter(sWriter);
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                out.println("<error context=\"" + this.enc(this.getContext(request.getContextPath())) + "\">");
                out.println("<message>" + this.enc(this.getLongestMessage(th, "Error")) + "</message>");
                out.print("<detail><![CDATA[");
                th.printStackTrace(out);
                out.println("]]></detail>");
                out.println("</error>");
                out.flush();
                out.close();
                PrintWriter reallyOut = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
                this.m_styler.sendError(sWriter.toString(), reallyOut);
                reallyOut.flush();
                reallyOut.close();
            }
            catch (Exception e2) {
                this.log("Error sending error response to browser.", e2);
                throw new ServletException(th);
            }
        }
    }

    private String enc(String in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '\'') {
                out.append("&apos;");
                continue;
            }
            if (c == '\"') {
                out.append("&quot;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private String getLongestMessage(Throwable th, String longestSoFar) {
        Throwable cause;
        if (th.getMessage() != null && th.getMessage().length() > longestSoFar.length()) {
            longestSoFar = th.getMessage();
        }
        if ((cause = th.getCause()) == null) {
            return longestSoFar;
        }
        return this.getLongestMessage(cause, longestSoFar);
    }

    public void doGet(TrippiServer server, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (server == null) {
            throw new ServletException("No such triplestore.");
        }
        String type = request.getParameter("type");
        String template = request.getParameter("template");
        String lang = request.getParameter("lang");
        String query = request.getParameter("query");
        String limit = request.getParameter("limit");
        String distinct = request.getParameter("distinct");
        String format = request.getParameter("format");
        String dumbTypes = request.getParameter("dt");
        String stream = request.getParameter("stream");
        boolean streamImmediately = stream != null && (stream.toLowerCase().startsWith("t") || stream.toLowerCase().equals("on"));
        String flush = request.getParameter("flush");
        if (type == null && template == null && lang == null && query == null && limit == null && distinct == null && format == null) {
            TriplestoreWriter writer;
            boolean doFlush;
            if (flush == null || flush.equals("")) {
                flush = "false";
            }
            if ((doFlush = flush.toLowerCase().startsWith("t")) && (writer = this.m_server.getWriter()) != null) {
                writer.flushBuffer();
            }
            response.setContentType("text/html; charset=UTF-8");
            this.doForm(server, new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")), request.getRequestURL().toString(), request.getContextPath());
        } else {
            this.doFind(server, type, template, lang, query, limit, distinct, format, dumbTypes, streamImmediately, flush, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIndex(PrintWriter out, String requestURI, String contextPath) throws Exception {
        try {
            StringWriter sWriter = new StringWriter();
            PrintWriter sout = new PrintWriter(sWriter);
            sout.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            String href = this.enc(requestURI.replaceAll("/$", ""));
            sout.println("<trippi-server href=\"" + href + "\" context=\"" + this.enc(this.getContext(contextPath)) + "\">");
            for (TrippiProfile profile : this.m_connectors.keySet()) {
                sout.println("  <profile id=\"" + profile.getId() + "\" label=\"" + this.enc(profile.getLabel()) + "\" connector=\"" + profile.getConnectorClassName() + "\">");
                Map<String, String> config = profile.getConfiguration();
                for (String name : config.keySet()) {
                    String value = config.get(name);
                    sout.println("    <param name=\"" + name + "\" value=\"" + this.enc(value) + "\"/>");
                }
                sout.println("  </profile>");
            }
            sout.println("</trippi-server>");
            sout.flush();
            this.m_styler.sendIndex(sWriter.toString(), out);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (Exception ex) {
                this.log("Error closing response", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doForm(TrippiServer server, PrintWriter out, String requestURI, String contextPath) throws Exception {
        try {
            int i;
            int i2;
            StringWriter sWriter = new StringWriter();
            PrintWriter sout = new PrintWriter(sWriter);
            sout.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            TriplestoreReader reader = server.getReader();
            String href = this.enc(requestURI.replaceAll("/$", ""));
            sout.println("<query-service href=\"" + href + "\" context=\"" + this.enc(this.getContext(contextPath)) + "\">");
            sout.println("  <alias-map>");
            Map<String, String> map = reader.getAliasMap();
            for (String name : map.keySet()) {
                String uri = map.get(name);
                sout.println("    <alias name=\"" + name + "\" uri=\"" + this.enc(uri) + "\"/>");
            }
            sout.println("  </alias-map>");
            sout.println("  <triple-languages>");
            String[] langs = reader.listTripleLanguages();
            for (i2 = 0; i2 < langs.length; ++i2) {
                sout.println("    <language name=\"" + this.enc(langs[i2]) + "\"/>");
            }
            sout.println("  </triple-languages>");
            langs = reader.listTupleLanguages();
            sout.println("  <tuple-languages>");
            for (i2 = 0; i2 < langs.length; ++i2) {
                sout.println("    <language name=\"" + this.enc(langs[i2]) + "\"/>");
            }
            sout.println("  </tuple-languages>");
            sout.println("  <triple-output-formats>");
            RDFFormat[] formats = TripleIterator.OUTPUT_FORMATS;
            for (i = 0; i < formats.length; ++i) {
                sout.println("    <format name=\"" + this.enc(formats[i].getName()) + "\" encoding=\"" + formats[i].getEncoding() + "\" media-type=\"" + formats[i].getMediaType() + "\" extension=\"" + formats[i].getExtension() + "\"/>");
            }
            sout.println("  </triple-output-formats>");
            sout.println("  <tuple-output-formats>");
            formats = TupleIterator.OUTPUT_FORMATS;
            for (i = 0; i < formats.length; ++i) {
                sout.println("    <format name=\"" + this.enc(formats[i].getName()) + "\" encoding=\"" + formats[i].getEncoding() + "\" media-type=\"" + formats[i].getMediaType() + "\" extension=\"" + formats[i].getExtension() + "\"/>");
            }
            sout.println("  </tuple-output-formats>");
            sout.println("</query-service>");
            sout.flush();
            this.m_styler.sendForm(sWriter.toString(), out);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (Exception ex) {
                this.log("Error closing response", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFind(TrippiServer server, String type, String template, String lang, String query, String limit, String distinct, String format, String dumbTypes, boolean streamImmediately, String flush, HttpServletResponse response) throws Exception {
        block12: {
            OutputStream out = null;
            File tempFile = null;
            try {
                if (streamImmediately) {
                    String mediaType = TrippiServer.getResponseMediaType(format, type == null || !type.equals("triples"), TrippiServer.getBoolean(dumbTypes, false));
                    try {
                        response.setContentType(mediaType + "; charset=UTF-8");
                        out = response.getOutputStream();
                        server.find(type, template, lang, query, limit, distinct, format, dumbTypes, flush, out);
                        break block12;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ServletException("Error querying", (Throwable)e);
                    }
                }
                tempFile = File.createTempFile("trippi", "result");
                FileOutputStream tempOut = new FileOutputStream(tempFile);
                String mediaType = server.find(type, template, lang, query, limit, distinct, format, dumbTypes, flush, tempOut);
                tempOut.close();
                response.setContentType(mediaType + "; charset=UTF-8");
                out = response.getOutputStream();
                FileInputStream results = new FileInputStream(tempFile);
                this.sendStream(results, out);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStream(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                this.log("Could not close result inputstream.");
            }
        }
    }

    public void destroy() {
        if (this.closeOnDestroy()) {
            if (this.m_connector != null) {
                try {
                    this.m_connector.close();
                }
                catch (Exception e) {
                    this.log("Error closing connector", e);
                }
            } else if (this.m_connectors != null) {
                for (TriplestoreConnector conn : this.m_connectors.values()) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        this.log("Error closing connector", e);
                    }
                }
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

