/*
 * Decompiled with CFR 0.152.
 */
package beowulf.applications.fviewer;

import beowulf.applications.fviewer.Actions;
import beowulf.gui.JFunction;
import beowulf.gui.PopupListener;
import beowulf.gui.Utility;
import beowulf.model.math.function.Absolute;
import beowulf.model.math.function.ArcCosine;
import beowulf.model.math.function.ArcSine;
import beowulf.model.math.function.ArcTangent;
import beowulf.model.math.function.Ceiling;
import beowulf.model.math.function.Constant;
import beowulf.model.math.function.Cosine;
import beowulf.model.math.function.Difference;
import beowulf.model.math.function.Exponential;
import beowulf.model.math.function.Floor;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.FunctionTreeModel;
import beowulf.model.math.function.Logarithm;
import beowulf.model.math.function.Power;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.Quotient;
import beowulf.model.math.function.Sine;
import beowulf.model.math.function.SquareRoot;
import beowulf.model.math.function.Sum;
import beowulf.model.math.function.Tangent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class FViewer
extends JFrame
implements ActionListener,
Observer {
    private static final long serialVersionUID = 4120853243950870832L;
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 600;
    private static final String FUNCTION_COLOR_CMD = "F Color...";
    private static final String COMBO_TO_TREE_CMD = "Load F into Tree";
    private static final int DEFAULT_STEPS = 100;
    private static final Color DEFAULT_COLOR = Color.red;
    private static final boolean DEFAULT_VISIBILITY = true;
    private static final Function DEFAULT_FUNCTION = new Power();
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    protected static final Function[] knownFunctionTypes = new Function[]{new Absolute(), new ArcCosine(), new ArcSine(), new ArcTangent(), new Ceiling(), new Constant(), new Cosine(), new Difference(), new Exponential(), new Floor(), new Logarithm(), new Power(), new Product(), new Quotient(), new Sine(), new SquareRoot(), new Sum(), new Tangent()};
    protected JToolBar functionToolBar;
    protected DefaultComboBoxModel functionList = new DefaultComboBoxModel();
    protected FunctionTreeModel treeModel;
    protected JTree treeDisplay;
    protected JFunction panel = new JFunction();
    protected JTextField domainMinBox = new JTextField(Double.toString(this.panel.getDomainMin()), 5);
    protected JTextField domainMaxBox = new JTextField(Double.toString(this.panel.getDomainMax()), 5);
    protected JTextField rangeMinBox = new JTextField(Double.toString(this.panel.getRangeMin()), 5);
    protected JTextField rangeMaxBox = new JTextField(Double.toString(this.panel.getRangeMax()), 5);
    protected JTextField minGridBox = new JTextField(Integer.toString(this.panel.getMinGridLines()), 5);
    protected JTextField maxGridBox = new JTextField(Integer.toString(this.panel.getMaxGridLines()), 5);
    protected JTextField multiplierBox = new JTextField(Double.toString(this.panel.getGridMultiplier()), 5);
    protected JCheckBox visibleBox = new JCheckBox("Show Function", true);
    protected JTextField stepBox = new JTextField(Integer.toString(100), 5);
    protected JButton colorButton = new JButton("F Color...");
    static /* synthetic */ Class class$beowulf$model$math$function$Function;

    protected FViewer() {
        super("Function Viewer");
        this.setDefaultCloseOperation(3);
        this.panel.addObserver(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setJMenuBar(this.createJMenuBar());
        this.functionToolBar = this.createFunctionToolBar();
        JSplitPane jSplitPane = new JSplitPane(1, this.getLeftPanel(), this.panel);
        jSplitPane.setOneTouchExpandable(true);
        container.add((Component)jSplitPane, "Center");
        container.add((Component)this.functionToolBar, "West");
        this.setSize(Math.max(800, this.getWidth()), Math.max(600, this.getHeight()));
        this.setLocation((int)(screenSize.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(screenSize.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
        this.setVisible(true);
    }

    protected JMenuBar createJMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem(Actions.getLoadFunctionInstance(this));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Actions.getSaveFunctionInstance(this));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(Actions.getExitInstance(this));
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        jMenuItem = new JMenuItem(Actions.getCutNodeInstance(this));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Actions.getCopyNodeInstance(this));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Actions.getPasteNodeInstance(this));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(Actions.getRemoveNodeInstance(this));
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Node");
        jMenu.setMnemonic(78);
        jMenuItem = new JMenuItem(Actions.getGetDerivativeInstance(this));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(Actions.getEditNodeInstance(this));
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    protected JToolBar createFunctionToolBar() {
        JToolBar jToolBar = new JToolBar(1);
        for (int i = 0; i < knownFunctionTypes.length; ++i) {
            jToolBar.add(new FunctionSource(knownFunctionTypes[i]));
        }
        return jToolBar;
    }

    protected JComponent getBottomLeftPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.treeModel = new FunctionTreeModel((Function)DEFAULT_FUNCTION.clone());
        this.treeDisplay = new JTree(this.treeModel);
        this.treeDisplay.setShowsRootHandles(true);
        this.treeDisplay.setTransferHandler(new FunctionTransferHandler());
        this.treeDisplay.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() != 2) {
                    return;
                }
                Actions.getEditNodeInstance(FViewer.this).actionPerformed(null);
            }
        });
        this.treeDisplay.getSelectionModel().setSelectionMode(1);
        Actions.CopyNodeAction copyNodeAction = Actions.getCopyNodeInstance(this);
        Actions.CutNodeAction cutNodeAction = Actions.getCutNodeInstance(this);
        Actions.PasteNodeAction pasteNodeAction = Actions.getPasteNodeInstance(this);
        this.treeDisplay.getInputMap().put(KeyStroke.getKeyStroke("ctrl C"), copyNodeAction.getValue("Name"));
        this.treeDisplay.getActionMap().put(copyNodeAction.getValue("Name"), copyNodeAction);
        this.treeDisplay.getInputMap().put(KeyStroke.getKeyStroke("ctrl X"), cutNodeAction.getValue("Name"));
        this.treeDisplay.getActionMap().put(cutNodeAction.getValue("Name"), cutNodeAction);
        this.treeDisplay.getInputMap().put(KeyStroke.getKeyStroke("ctrl V"), pasteNodeAction.getValue("Name"));
        this.treeDisplay.getActionMap().put(pasteNodeAction.getValue("Name"), pasteNodeAction);
        jPanel.add((Component)new JScrollPane(this.treeDisplay), "Center");
        JComponent jComponent = new JPopupMenu();
        AbstractButton abstractButton = new JMenuItem(Actions.getEditNodeInstance(this));
        ((JPopupMenu)jComponent).add((JMenuItem)abstractButton);
        abstractButton = new JMenuItem(Actions.getRemoveNodeInstance(this));
        ((JPopupMenu)jComponent).add((JMenuItem)abstractButton);
        ((JPopupMenu)jComponent).addSeparator();
        abstractButton = new JMenuItem(Actions.getCutNodeInstance(this));
        ((JPopupMenu)jComponent).add((JMenuItem)abstractButton);
        abstractButton = new JMenuItem(Actions.getCopyNodeInstance(this));
        ((JPopupMenu)jComponent).add((JMenuItem)abstractButton);
        abstractButton = new JMenuItem(Actions.getPasteNodeInstance(this));
        ((JPopupMenu)jComponent).add((JMenuItem)abstractButton);
        this.treeDisplay.addMouseListener(new PopupListener((JPopupMenu)jComponent));
        jComponent = new JPanel(new GridLayout(2, 2));
        abstractButton = new JButton(Actions.getAddFunctionInstance(this));
        jComponent.add(abstractButton);
        abstractButton = new JButton(Actions.getEditNodeInstance(this));
        jComponent.add(abstractButton);
        abstractButton = new JButton(Actions.getRemoveNodeInstance(this));
        jComponent.add(abstractButton);
        abstractButton = new JButton(Actions.getGetDerivativeInstance(this));
        jComponent.add(abstractButton);
        jPanel.add((Component)jComponent, "South");
        return jPanel;
    }

    protected JComponent getLeftPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add(new JComboBox(this.functionList), "North");
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 2, 2));
        jPanel2.add(Utility.addLabelLeft("Domain Min: ", this.domainMinBox));
        this.domainMinBox.addActionListener(this);
        jPanel2.add(Utility.addLabelLeft("Range Min: ", this.rangeMinBox));
        this.rangeMinBox.addActionListener(this);
        jPanel2.add(Utility.addLabelLeft("Domain Max: ", this.domainMaxBox));
        this.domainMaxBox.addActionListener(this);
        jPanel2.add(Utility.addLabelLeft("Range Max: ", this.rangeMaxBox));
        this.rangeMaxBox.addActionListener(this);
        jPanel2.add(Utility.addLabelLeft("Min. Dist: ", this.minGridBox));
        this.minGridBox.addActionListener(this);
        jPanel2.add(Utility.addLabelLeft("Max Dist: ", this.maxGridBox));
        this.maxGridBox.addActionListener(this);
        jPanel2.add(Utility.addLabelLeft("Multiplier: ", this.multiplierBox));
        this.multiplierBox.addActionListener(this);
        jTabbedPane.addTab("Grid Properties", jPanel2);
        jPanel2 = new JPanel(new GridLayout(0, 2, 2, 2));
        jPanel2.add(this.visibleBox);
        jPanel2.add(Utility.addLabelLeft("F Step Ct: ", this.stepBox));
        this.colorButton.setBackground(DEFAULT_COLOR);
        this.colorButton.addActionListener(this);
        jPanel2.add(this.colorButton);
        JComponent jComponent = new JButton(COMBO_TO_TREE_CMD);
        ((AbstractButton)jComponent).addActionListener(this);
        jPanel2.add(jComponent);
        jComponent = new JButton(Actions.getRemoveFunctionInstance(this));
        jPanel2.add(jComponent);
        jComponent = new JButton(Actions.getUpdateFunctionInstance(this));
        jPanel2.add(jComponent);
        jTabbedPane.addTab("Function Properties", jPanel2);
        jPanel.add((Component)jTabbedPane, "Center");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)new JPanel(), "Center");
        jComponent = new JSplitPane(0, jPanel2, this.getBottomLeftPanel());
        ((JSplitPane)jComponent).setOneTouchExpandable(true);
        return jComponent;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string != null) {
                if (string.equals(COMBO_TO_TREE_CMD)) {
                    JFunction.FunctionData functionData = (JFunction.FunctionData)this.functionList.getSelectedItem();
                    if (functionData != null) {
                        this.stepBox.setText(Integer.toString(functionData.steps));
                        this.visibleBox.setSelected(functionData.visible);
                        this.colorButton.setBackground(functionData.color);
                        this.treeModel.setRoot((Function)functionData.f.clone());
                    } else {
                        this.stepBox.setText(Integer.toString(100));
                        this.visibleBox.setSelected(true);
                        this.colorButton.setBackground(DEFAULT_COLOR);
                        this.treeModel.setRoot((Function)DEFAULT_FUNCTION.clone());
                    }
                } else if (string.equals(FUNCTION_COLOR_CMD)) {
                    Color color = JColorChooser.showDialog(this, "Choose F's color", this.colorButton.getBackground());
                    if (color != null) {
                        this.colorButton.setBackground(color);
                    }
                } else {
                    this.panel.setDomainMin(Double.parseDouble(this.domainMinBox.getText()));
                    this.panel.setDomainMax(Double.parseDouble(this.domainMaxBox.getText()));
                    this.panel.setRangeMin(Double.parseDouble(this.rangeMinBox.getText()));
                    this.panel.setRangeMax(Double.parseDouble(this.rangeMaxBox.getText()));
                    this.panel.setMinGridLines(Integer.parseInt(this.minGridBox.getText()));
                    this.panel.setMaxGridLines(Integer.parseInt(this.maxGridBox.getText()));
                    this.panel.setGridMultiplier(Double.parseDouble(this.multiplierBox.getText()));
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
        }
        this.repaint();
    }

    public void update(Observable observable, Object object) {
        this.domainMinBox.setText(Double.toString(this.panel.getDomainMin()));
        this.domainMaxBox.setText(Double.toString(this.panel.getDomainMax()));
        this.rangeMinBox.setText(Double.toString(this.panel.getRangeMin()));
        this.rangeMaxBox.setText(Double.toString(this.panel.getRangeMax()));
    }

    public static final void main(String[] stringArray) {
        new FViewer();
    }

    private static class FunctionTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 3257289149407966001L;
        DataFlavor localFunctionFlavor;
        DataFlavor serialFunctionFlavor;
        String localArrayListType = "application/x-java-jvm-local-objectref;class=beowulf.model.math.function.Function";
        FunctionSource source = null;

        protected FunctionTransferHandler() {
            try {
                this.localFunctionFlavor = new DataFlavor(this.localArrayListType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("ArrayListTransferHandler: unable to create data flavor");
            }
            this.serialFunctionFlavor = new DataFlavor(class$beowulf$model$math$function$Function == null ? (class$beowulf$model$math$function$Function = FViewer.class$("beowulf.model.math.function.Function")) : class$beowulf$model$math$function$Function, "Function");
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            Function function;
            JTree jTree;
            block10: {
                jTree = null;
                function = null;
                if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                    return false;
                }
                try {
                    jTree = (JTree)jComponent;
                    if (this.hasLocalFunctionFlavor(transferable.getTransferDataFlavors())) {
                        function = (Function)transferable.getTransferData(this.localFunctionFlavor);
                        break block10;
                    }
                    if (this.hasSerialFunctionFlavor(transferable.getTransferDataFlavors())) {
                        function = (Function)transferable.getTransferData(this.serialFunctionFlavor);
                        break block10;
                    }
                    return false;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    System.out.println("importData: unsupported data flavor");
                    return false;
                }
                catch (IOException iOException) {
                    System.out.println("importData: I/O exception");
                    return false;
                }
            }
            if (!(jTree.getModel() instanceof FunctionTreeModel)) {
                return false;
            }
            FunctionTreeModel functionTreeModel = (FunctionTreeModel)jTree.getModel();
            TreePath treePath = jTree.getSelectionPath();
            if (treePath == null) {
                return false;
            }
            Function function2 = (Function)treePath.getLastPathComponent();
            if (function2 == functionTreeModel.getRoot()) {
                functionTreeModel.setRoot(function);
            } else {
                Function function3 = functionTreeModel.getParent(function2);
                int n = functionTreeModel.getIndexOfChild(function3, function2);
                functionTreeModel.insert(function3, function, n);
            }
            return true;
        }

        private boolean hasLocalFunctionFlavor(DataFlavor[] dataFlavorArray) {
            if (this.localFunctionFlavor == null) {
                return false;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(this.localFunctionFlavor)) continue;
                return true;
            }
            return false;
        }

        private boolean hasSerialFunctionFlavor(DataFlavor[] dataFlavorArray) {
            if (this.serialFunctionFlavor == null) {
                return false;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(this.serialFunctionFlavor)) continue;
                return true;
            }
            return false;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            if (this.hasLocalFunctionFlavor(dataFlavorArray)) {
                return true;
            }
            return this.hasSerialFunctionFlavor(dataFlavorArray);
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof FunctionSource) {
                this.source = (FunctionSource)jComponent;
                Function function = this.source.getNewFunction();
                return new FunctionTransferable(function);
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        private class FunctionTransferable
        implements Transferable {
            Function data;

            protected FunctionTransferable(Function function) {
                this.data = function;
            }

            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return this.data;
            }

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{FunctionTransferHandler.this.localFunctionFlavor, FunctionTransferHandler.this.serialFunctionFlavor};
            }

            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                if (FunctionTransferHandler.this.localFunctionFlavor.equals(dataFlavor)) {
                    return true;
                }
                return FunctionTransferHandler.this.serialFunctionFlavor.equals(dataFlavor);
            }
        }
    }

    private static class FunctionSource
    extends JLabel {
        private static final long serialVersionUID = 3258129159011315761L;
        protected Function type;

        protected FunctionSource(Function function) {
            super(function.toString(), 0);
            this.type = function;
            this.setTransferHandler(new FunctionTransferHandler());
            this.setBorder(BorderFactory.createBevelBorder(0));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    FunctionSource.this.getTransferHandler().exportAsDrag(FunctionSource.this, mouseEvent, 1);
                }
            });
        }

        protected Function getNewFunction() {
            return (Function)this.type.clone();
        }
    }
}

