/*
 * Decompiled with CFR 0.152.
 */
package beowulf.event;

import beowulf.model.graph.Edge;
import beowulf.model.graph.GraphModel;
import java.util.EventObject;

public class GraphEvent
extends EventObject {
    private static final long serialVersionUID = 3256728394048483378L;
    public static final int NODE_ADDED = 1;
    public static final int NODE_REMOVED = 2;
    public static final int EDGE_ADDED = 3;
    public static final int EDGE_REMOVED = 4;
    protected int eventType;
    protected Object nodeValue;
    protected Edge edgeValue;

    public int getEventType() {
        return this.eventType;
    }

    public Object getNodeValue() {
        return this.nodeValue;
    }

    public GraphEvent(GraphModel graphModel, int n, Object object) {
        super(graphModel);
        this.eventType = n;
        this.nodeValue = object;
    }

    public GraphEvent(GraphModel graphModel, int n, Edge edge) {
        super(graphModel);
        this.eventType = n;
        this.edgeValue = edge;
    }

    public String toString() {
        String string = "GraphEvent: [Node Value:  " + this.nodeValue + ", Edge Value: " + this.edgeValue + ", EventType: ";
        switch (this.eventType) {
            case 1: {
                return string + "Node Added]";
            }
            case 2: {
                return string + "Node Removed]";
            }
            case 3: {
                return string + "Edge Added]";
            }
            case 4: {
                return string + "Edge Removed]";
            }
        }
        return string + "unknown]";
    }
}

