/*
 * Decompiled with CFR 0.152.
 */
package beowulf.gui;

import beowulf.gui.DCMouseEventReceiver;
import beowulf.gui.DraggableContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class DraggableComponent
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 3258407339748242226L;
    protected JComponent component;
    protected DraggableContainer container;
    protected boolean dragging;
    protected boolean hovering;
    protected int oldX;
    protected int oldY;

    public JComponent getComponent() {
        return this.component;
    }

    public boolean getDragging() {
        return this.dragging;
    }

    public boolean getHovering() {
        return this.hovering;
    }

    public boolean getSelected() {
        return this.container.getCurrentComponent() == this;
    }

    public DraggableContainer getDraggableContainer() {
        return this.container;
    }

    public void setDraggableContainer(DraggableContainer draggableContainer) {
        this.container = draggableContainer;
    }

    private DraggableComponent() {
    }

    public DraggableComponent(DraggableContainer draggableContainer, JComponent jComponent) {
        this(draggableContainer, jComponent, 0, 0);
    }

    public DraggableComponent(DraggableContainer draggableContainer, JComponent jComponent, int n, int n2) {
        this.component = jComponent;
        this.add(this.component);
        this.component.setLocation(2, 2);
        this.component.setSize(this.component.getPreferredSize());
        this.setBounds(n, n2, this.component.getWidth() + 4, this.component.getHeight() + 4);
        this.container = draggableContainer;
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this == mouseEvent.getSource()) {
            this.hovering = true;
            this.getTopLevelAncestor().repaint();
        }
        if (this.component instanceof DCMouseEventReceiver) {
            ((DCMouseEventReceiver)((Object)this.component)).mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this == mouseEvent.getSource()) {
            this.hovering = false;
            this.getTopLevelAncestor().repaint();
        }
        if (this.component instanceof DCMouseEventReceiver) {
            ((DCMouseEventReceiver)((Object)this.component)).mouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this == mouseEvent.getSource() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.dragging = false;
            if (this.container.getCurrentComponent() != this) {
                this.container.setCurrentComponent(null);
            }
            this.oldX = mouseEvent.getX();
            this.oldY = mouseEvent.getY();
            this.getTopLevelAncestor().repaint();
        }
        if (this.component instanceof DCMouseEventReceiver) {
            ((DCMouseEventReceiver)((Object)this.component)).mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this == mouseEvent.getSource()) {
            if (this.dragging) {
                this.container.setCurrentComponent(this);
            }
            this.dragging = false;
            if (this.getX() < 0) {
                this.setLocation(0, this.getY());
            }
            if (this.getY() < 0) {
                this.setLocation(this.getX(), 0);
            }
            if (this.getX() >= this.container.getWidth()) {
                this.setLocation(this.container.getWidth() - this.getWidth(), this.getY());
            }
            if (this.getY() >= this.container.getHeight()) {
                this.setLocation(this.getX(), this.container.getHeight() - this.getHeight());
            }
            this.getTopLevelAncestor().repaint();
        }
        if (this.component instanceof DCMouseEventReceiver) {
            ((DCMouseEventReceiver)((Object)this.component)).mouseReleased(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this == mouseEvent.getSource() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.container.getCurrentComponent() == this) {
                this.container.setCurrentComponent(null);
            } else {
                this.container.setCurrentComponent(this);
            }
            this.getTopLevelAncestor().repaint();
        }
        if (this.component instanceof DCMouseEventReceiver) {
            ((DCMouseEventReceiver)((Object)this.component)).mouseClicked(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this == mouseEvent.getSource()) {
            this.setLocation(this.getX() + (mouseEvent.getX() - this.oldX), this.getY() + (mouseEvent.getY() - this.oldY));
            this.dragging = true;
            this.getTopLevelAncestor().repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paintComponent(Graphics graphics) {
        if (this.dragging) {
            graphics.setColor(Color.blue.brighter());
        } else if (this == this.container.getCurrentComponent()) {
            graphics.setColor(Color.green);
        } else if (this.hovering) {
            graphics.setColor(Color.yellow);
        } else {
            return;
        }
        graphics.drawRect(1, 1, this.component.getWidth() + 1, this.component.getHeight() + 1);
        graphics.drawRect(0, 0, this.component.getWidth() + 3, this.component.getHeight() + 3);
    }
}

