/*
 * Decompiled with CFR 0.152.
 */
package beowulf.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HideablePanel
extends JPanel {
    private static final long serialVersionUID = 3258125877689988919L;
    private EventHandler handler = new EventHandler();
    private boolean resizeable = true;
    private JPanel centerPanel = new JPanel(new BorderLayout());
    private JComponent component;
    private JLabel titleLabel = new JLabel();
    private JComponent grippablePanel = (JComponent)Box.createVerticalStrut(5);

    public HideablePanel(JComponent jComponent) {
        this(jComponent, "", true);
    }

    public HideablePanel(JComponent jComponent, boolean bl) {
        this(jComponent, "", bl);
    }

    public HideablePanel(JComponent jComponent, String string) {
        this(jComponent, string, true);
    }

    public HideablePanel(JComponent jComponent, String string, boolean bl) {
        super(new BorderLayout(), bl);
        this.component = jComponent;
        this.titleLabel.setText(string);
        this.grippablePanel.setBorder(BorderFactory.createBevelBorder(0));
        this.grippablePanel.setCursor(Cursor.getPredefinedCursor(8));
        JButton jButton = new JButton("-");
        jButton.addActionListener(this.handler);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.titleLabel, "West");
        jPanel.add((Component)new JPanel(), "Center");
        jPanel.add((Component)jButton, "East");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.component, "Center");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.centerPanel.add((Component)this.grippablePanel, "South");
        this.centerPanel.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.addMouseListener(this.handler);
        this.addMouseMotionListener(this.handler);
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    public void setResizeable(boolean bl) {
        this.resizeable = bl;
        if (this.resizeable) {
            this.centerPanel.add((Component)this.grippablePanel, "South");
        } else {
            this.centerPanel.remove(this.grippablePanel);
        }
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    private class EventHandler
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        private int oldY;
        private boolean dragValid = false;
        private boolean hidden = false;

        private EventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(actionEvent.getSource() instanceof JButton)) {
                return;
            }
            String string = actionEvent.getActionCommand();
            JButton jButton = (JButton)actionEvent.getSource();
            if (string == null || !string.equals("-") && !string.equals("+")) {
                return;
            }
            boolean bl = this.hidden = !this.hidden;
            if (string.equals("+")) {
                jButton.setText("-");
                HideablePanel.this.add((Component)HideablePanel.this.centerPanel, "Center");
            } else if (string.equals("-")) {
                HideablePanel.this.remove(HideablePanel.this.centerPanel);
                jButton.setText("+");
            }
            HideablePanel.this.revalidate();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() != HideablePanel.this) {
                return;
            }
            this.oldY = mouseEvent.getY();
            this.dragValid = this.oldY >= HideablePanel.this.getHeight() - 6;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.dragValid || !HideablePanel.this.resizeable) {
                return;
            }
            Dimension dimension = HideablePanel.this.component.getPreferredSize();
            dimension.height = Math.max(dimension.height + mouseEvent.getY() - this.oldY, 0);
            this.oldY = mouseEvent.getY();
            HideablePanel.this.component.setPreferredSize(dimension);
            ((JComponent)HideablePanel.this.component.getParent()).revalidate();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

