/*
 * Decompiled with CFR 0.152.
 */
package beowulf.gui;

import beowulf.model.math.function.Function;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JPanel;

public class JFunction
extends JPanel {
    private static final long serialVersionUID = 3762817099361761593L;
    protected double domainMin = -2.0;
    protected double domainMax = 2.0;
    protected double rangeMin = -2.0;
    protected double rangeMax = 2.0;
    protected Color labelColor = Color.black;
    protected boolean drawLabels = true;
    protected DecimalFormat format = new DecimalFormat("0.######");
    protected Vector observers = new Vector();
    protected Vector functionList = new Vector();
    protected GridPanel gridPanel = new GridPanel();
    protected XLabelPanel xLabelPanel = new XLabelPanel();
    protected YLabelPanel yLabelPanel = new YLabelPanel();

    public JFunction() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.gridPanel, "Center");
        if (this.drawLabels) {
            this.add((Component)this.xLabelPanel, "East");
            this.add((Component)this.yLabelPanel, "North");
        }
    }

    protected double getSpacing(double d, double d2) {
        double d3 = this.gridPanel.gridInitialSpacing / d2;
        while (d / d3 < (double)this.getMinGridLines() * d2) {
            d3 /= this.getGridMultiplier();
        }
        while (d / d3 > (double)this.getMaxGridLines() * d2) {
            d3 *= this.getGridMultiplier();
        }
        return d3;
    }

    protected void graphFunction(Function function, Graphics graphics, int n) {
        try {
            double d = this.domainMin;
            double d2 = function.evaluate(d);
            double d3 = (this.domainMax - this.domainMin) / (double)n;
            double d4 = d + d3;
            double d5 = function.evaluate(d4);
            while (d <= this.domainMax) {
                if (!Double.isNaN(d5) && !Double.isNaN(d2)) {
                    graphics.drawLine(this.xWorldToScreen(d), this.yWorldToScreen(d2), this.xWorldToScreen(d4), this.yWorldToScreen(d5));
                }
                d = d4;
                d2 = d5;
                d5 = function.evaluate(d4 += d3);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected double xScreenToViewport(double d) {
        return 2.0 * d / (double)this.gridPanel.getWidth() - 1.0;
    }

    protected double yScreenToViewport(double d) {
        return 1.0 - 2.0 * d / (double)this.gridPanel.getHeight();
    }

    protected int xWorldToScreen(double d) {
        return (int)((double)this.gridPanel.getWidth() * (d - this.domainMin) / (this.domainMax - this.domainMin));
    }

    protected int yWorldToScreen(double d) {
        return (int)((double)this.gridPanel.getHeight() * (1.0 - (d - this.rangeMin) / (this.rangeMax - this.rangeMin)));
    }

    protected double xScreenToWorld(int n) {
        return (this.domainMax - this.domainMin) * (double)n / (double)this.gridPanel.getWidth() + this.domainMin;
    }

    protected double yScreenToWorld(int n) {
        return (this.rangeMax - this.rangeMin) * (double)(this.gridPanel.getHeight() - n) / (double)this.gridPanel.getHeight() + this.rangeMin;
    }

    public FunctionData getFunctionData(int n) {
        return (FunctionData)this.functionList.get(n);
    }

    public boolean removeFunction(FunctionData functionData) {
        return this.functionList.remove(functionData);
    }

    public int getFunctionCount() {
        return this.functionList.size();
    }

    public FunctionData removeFunction(int n) {
        return (FunctionData)this.functionList.remove(n);
    }

    public void addFunction(FunctionData functionData) {
        this.functionList.add(functionData);
    }

    public void addFunction(Function function) {
        this.addFunction(function, Color.red, 25, true);
    }

    public void addFunction(Function function, Color color) {
        this.addFunction(function, color, 25, true);
    }

    public void addFunction(Function function, Color color, int n) {
        this.addFunction(function, color, n, true);
    }

    public void addFunction(Function function, Color color, int n, boolean bl) {
        FunctionData functionData = new FunctionData();
        functionData.f = function;
        functionData.color = color;
        functionData.steps = n;
        functionData.visible = bl;
        this.functionList.add(functionData);
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observers.remove(observer);
    }

    protected void notifyObservers(Object object) {
        for (int i = 0; i < this.observers.size(); ++i) {
            ((Observer)this.observers.get(i)).update(null, object);
        }
    }

    public double getDomainMax() {
        return this.domainMax;
    }

    public double getDomainMin() {
        return this.domainMin;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public void setDomainMax(double d) {
        this.domainMax = d;
        this.notifyObservers(this);
    }

    public void setDomainMin(double d) {
        this.domainMin = d;
        this.notifyObservers(this);
    }

    public void setRangeMax(double d) {
        this.rangeMax = d;
        this.notifyObservers(this);
    }

    public void setRangeMin(double d) {
        this.rangeMin = d;
        this.notifyObservers(this);
    }

    public boolean isDrawLabels() {
        return this.drawLabels;
    }

    public void setDrawLabels(boolean bl) {
        this.drawLabels = bl;
        if (!this.drawLabels) {
            this.remove(this.xLabelPanel);
            this.remove(this.yLabelPanel);
        } else {
            this.add((Component)this.xLabelPanel, "East");
            this.add((Component)this.yLabelPanel, "North");
        }
        this.notifyObservers(this);
    }

    public Color getAxisColor() {
        return this.gridPanel.axisColor;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public int getZoomMask() {
        return this.gridPanel.zoomMask;
    }

    public void setAllowDrags(boolean bl) {
        this.gridPanel.allowDrags = bl;
        this.notifyObservers(this);
    }

    public void setAllowZooms(boolean bl) {
        this.gridPanel.allowZooms = bl;
        this.notifyObservers(this);
    }

    public void setDragMask(int n) {
        this.gridPanel.dragMask = n;
        this.notifyObservers(this);
    }

    public double getGridMultiplier() {
        return this.gridPanel.gridMultiplier;
    }

    public int getMaxGridLines() {
        return this.gridPanel.maxGridLines;
    }

    public int getMinGridLines() {
        return this.gridPanel.minGridLines;
    }

    public void setGridMultiplier(double d) {
        this.gridPanel.gridMultiplier = d;
        this.notifyObservers(this);
    }

    public void setMaxGridLines(int n) {
        if (n > this.gridPanel.minGridLines) {
            this.gridPanel.maxGridLines = n;
            this.notifyObservers(this);
        }
    }

    public void setMinGridLines(int n) {
        if (n < this.gridPanel.maxGridLines) {
            this.gridPanel.minGridLines = n;
            this.notifyObservers(this);
        }
    }

    public boolean isAllowDrags() {
        return this.gridPanel.allowDrags;
    }

    public boolean isAllowZooms() {
        return this.gridPanel.allowZooms;
    }

    public int getDragMask() {
        return this.gridPanel.dragMask;
    }

    public void setMajorGridColor(Color color) {
        this.gridPanel.majorGridColor = color;
        this.notifyObservers(this);
    }

    public void setMinorGridColor(Color color) {
        this.gridPanel.minorGridColor = color;
        this.notifyObservers(this);
    }

    public void setAxisColor(Color color) {
        this.gridPanel.axisColor = color;
        this.notifyObservers(this);
    }

    public Color getMajorGridColor() {
        return this.gridPanel.majorGridColor;
    }

    public Color getMinorGridColor() {
        return this.gridPanel.minorGridColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
        this.notifyObservers(this);
    }

    public void setZoomMask(int n) {
        this.gridPanel.zoomMask = n;
        this.notifyObservers(this);
    }

    public static class FunctionData {
        public Function f;
        public Color color;
        public boolean visible;
        public int steps;

        public String toString() {
            return this.f.toString();
        }
    }

    private class GridPanel
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        private static final long serialVersionUID = 3545793286691566132L;
        protected double gridInitialSpacing = 1.0;
        protected int minGridLines = 2;
        protected int maxGridLines = 10;
        protected double gridMultiplier = 5.0;
        protected boolean allowDrags = true;
        protected int dragMask = 128;
        protected boolean allowZooms = true;
        protected int zoomMask = 64;
        protected Color axisColor = Color.orange;
        protected Color majorGridColor = Color.darkGray;
        protected Color minorGridColor = Color.lightGray;
        protected double oldX;
        protected double oldY;

        protected GridPanel() {
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = graphics.getColor();
            this.drawGrid(graphics);
            for (int i = 0; i < JFunction.this.functionList.size(); ++i) {
                FunctionData functionData = (FunctionData)JFunction.this.functionList.get(i);
                if (!functionData.visible) continue;
                graphics.setColor(functionData.color);
                JFunction.this.graphFunction(functionData.f, graphics, functionData.steps);
            }
            graphics.setColor(color);
        }

        protected void drawGrid(Graphics graphics) {
            this.drawGrid(this.gridMultiplier, this.minorGridColor, graphics);
            this.drawGrid(1.0, this.majorGridColor, graphics);
            graphics.setColor(this.axisColor);
            graphics.drawLine(JFunction.this.xWorldToScreen(JFunction.this.domainMin), JFunction.this.yWorldToScreen(0.0), JFunction.this.xWorldToScreen(JFunction.this.domainMax), JFunction.this.yWorldToScreen(0.0));
            graphics.drawLine(JFunction.this.xWorldToScreen(0.0), JFunction.this.yWorldToScreen(JFunction.this.rangeMin), JFunction.this.xWorldToScreen(0.0), JFunction.this.yWorldToScreen(JFunction.this.rangeMax));
        }

        protected void drawGrid(double d, Color color, Graphics graphics) {
            double d2;
            int n;
            graphics.setColor(color);
            double d3 = JFunction.this.getSpacing(JFunction.this.rangeMax - JFunction.this.rangeMin, d);
            int n2 = (int)Math.floor(JFunction.this.rangeMax / d3);
            for (n = (int)Math.ceil(JFunction.this.rangeMin / d3); n <= n2; ++n) {
                d2 = (double)n * d3;
                graphics.drawLine(JFunction.this.xWorldToScreen(JFunction.this.domainMin), JFunction.this.yWorldToScreen(d2), JFunction.this.xWorldToScreen(JFunction.this.domainMax), JFunction.this.yWorldToScreen(d2));
            }
            d3 = JFunction.this.getSpacing(JFunction.this.domainMax - JFunction.this.domainMin, d);
            n2 = (int)Math.floor(JFunction.this.domainMax / d3);
            for (n = (int)Math.ceil(JFunction.this.domainMin / d3); n <= n2; ++n) {
                d2 = (double)n * d3;
                graphics.drawLine(JFunction.this.xWorldToScreen(d2), JFunction.this.yWorldToScreen(JFunction.this.rangeMin), JFunction.this.xWorldToScreen(d2), JFunction.this.yWorldToScreen(JFunction.this.rangeMax));
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            double d = JFunction.this.xScreenToViewport(mouseEvent.getX()) - this.oldX;
            double d2 = JFunction.this.yScreenToViewport(mouseEvent.getY()) - this.oldY;
            if (this.allowDrags && (mouseEvent.getModifiersEx() & this.dragMask) == this.dragMask) {
                double d3 = JFunction.this.domainMax - JFunction.this.domainMin;
                double d4 = JFunction.this.rangeMax - JFunction.this.rangeMin;
                JFunction.this.domainMin -= d * d3 / 2.0;
                JFunction.this.domainMax -= d * d3 / 2.0;
                JFunction.this.rangeMin -= d2 * d4 / 2.0;
                JFunction.this.rangeMax -= d2 * d4 / 2.0;
                JFunction.this.notifyObservers(this);
            } else if (this.allowZooms && (mouseEvent.getModifiersEx() & this.zoomMask) == this.zoomMask) {
                float f = (float)Math.pow(1.01, d2 * (double)this.getHeight() / 2.0);
                double d5 = (JFunction.this.domainMin + JFunction.this.domainMax) / 2.0;
                double d6 = (JFunction.this.rangeMin + JFunction.this.rangeMax) / 2.0;
                JFunction.this.domainMin = (double)f * (JFunction.this.domainMin - d5) + d5;
                JFunction.this.domainMax = (double)f * (JFunction.this.domainMax - d5) + d5;
                JFunction.this.rangeMin = (double)f * (JFunction.this.rangeMin - d6) + d6;
                JFunction.this.rangeMax = (double)f * (JFunction.this.rangeMax - d6) + d6;
                JFunction.this.notifyObservers(this);
            }
            this.oldX = JFunction.this.xScreenToViewport(mouseEvent.getX());
            this.oldY = JFunction.this.yScreenToViewport(mouseEvent.getY());
            JFunction.this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.oldX = JFunction.this.xScreenToViewport(mouseEvent.getX());
            this.oldY = JFunction.this.yScreenToViewport(mouseEvent.getY());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                double d = (JFunction.this.domainMax + JFunction.this.domainMin) / 2.0;
                double d2 = JFunction.this.xScreenToWorld(mouseEvent.getX()) - d;
                JFunction.this.setDomainMax(JFunction.this.getDomainMax() + d2);
                JFunction.this.setDomainMin(JFunction.this.getDomainMin() + d2);
                d = (JFunction.this.rangeMax + JFunction.this.rangeMin) / 2.0;
                d2 = JFunction.this.yScreenToWorld(mouseEvent.getY()) - d;
                JFunction.this.setRangeMax(JFunction.this.getRangeMax() + d2);
                JFunction.this.setRangeMin(JFunction.this.getRangeMin() + d2);
                this.getParent().repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private class YLabelPanel
    extends JPanel {
        private static final long serialVersionUID = 3834594322262995760L;

        private YLabelPanel() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (!JFunction.this.drawLabels) {
                return;
            }
            graphics.setColor(JFunction.this.labelColor);
            int n = graphics.getFontMetrics().getAscent();
            double d = JFunction.this.getSpacing(JFunction.this.domainMax - JFunction.this.domainMin, 1.0);
            int n2 = (int)Math.floor(JFunction.this.domainMax / d);
            for (int i = (int)Math.ceil(JFunction.this.domainMin / d); i <= n2; ++i) {
                double d2 = (double)i * d;
                String string = JFunction.this.format.format(d2);
                int n3 = graphics.getFontMetrics().stringWidth(string);
                graphics.drawString(string, JFunction.this.xWorldToScreen(d2) - n3 / 2, n);
            }
            this.setPreferredSize(new Dimension(this.getWidth(), graphics.getFontMetrics().getHeight()));
            this.revalidate();
        }
    }

    private class XLabelPanel
    extends JPanel {
        private static final long serialVersionUID = 3617009737120364855L;

        private XLabelPanel() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (!JFunction.this.drawLabels) {
                return;
            }
            graphics.setColor(JFunction.this.labelColor);
            int n = graphics.getFontMetrics().getAscent();
            int n2 = 0;
            double d = JFunction.this.getSpacing(JFunction.this.rangeMax - JFunction.this.rangeMin, 1.0);
            int n3 = (int)Math.floor(JFunction.this.rangeMax / d);
            for (int i = (int)Math.ceil(JFunction.this.rangeMin / d); i <= n3; ++i) {
                double d2 = (double)i * d;
                String string = JFunction.this.format.format(d2);
                int n4 = graphics.getFontMetrics().stringWidth(string);
                n2 = Math.max(n2, n4);
                graphics.drawString(string, 0, JFunction.this.yWorldToScreen(d2) + n / 2);
            }
            this.setPreferredSize(new Dimension(n2, this.getHeight()));
            this.revalidate();
        }
    }
}

