/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Constant;
import beowulf.model.math.function.Difference;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.Quotient;
import beowulf.model.math.function.SquareRoot;
import beowulf.model.math.function.UnaryFunction;

public final class ArcCosine
extends UnaryFunction {
    private static final long serialVersionUID = 3258412828816912689L;

    public ArcCosine() {
    }

    public ArcCosine(Function function) {
        super(function);
    }

    public double evaluate(double d) {
        return Math.acos(this.f.evaluate(d));
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = Product.createProduct((Function)this.f.clone(), (Function)this.f.clone());
        SquareRoot squareRoot = new SquareRoot(Difference.createDifference(new Constant(1.0), function));
        return Quotient.createQuotient(Product.createProduct(new Constant(-1.0), this.f.getDerivative()), squareRoot);
    }

    public Object clone() {
        if (this.f == null) {
            return new ArcCosine();
        }
        return new ArcCosine((Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "acos(x)" : "acos(" + this.f + ")";
    }
}

