/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Constant;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.Quotient;
import beowulf.model.math.function.Sum;
import beowulf.model.math.function.UnaryFunction;

public final class ArcTangent
extends UnaryFunction {
    private static final long serialVersionUID = 4050197553041782579L;

    public ArcTangent() {
    }

    public ArcTangent(Function function) {
        super(function);
    }

    public double evaluate(double d) {
        return Math.atan(this.f.evaluate(d));
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = Product.createProduct((Function)this.f.clone(), (Function)this.f.clone());
        Function function2 = Sum.createSum(new Constant(1.0), function);
        return Quotient.createQuotient(this.f.getDerivative(), function2);
    }

    public Object clone() {
        if (this.f == null) {
            return new ArcTangent();
        }
        return new ArcTangent((Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "atan(x)" : "atan(" + this.f + ")";
    }
}

