/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Constant;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.Sine;
import beowulf.model.math.function.UnaryFunction;

public final class Cosine
extends UnaryFunction {
    private static final long serialVersionUID = 3835150666523097397L;

    public Cosine() {
    }

    public Cosine(Function function) {
        super(function);
    }

    public double evaluate(double d) {
        return Math.cos(this.f.evaluate(d));
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = Product.createProduct(new Constant(-1.0), new Sine((Function)this.f.clone()));
        return Product.createProduct(function, this.f.getDerivative());
    }

    public Object clone() {
        if (this.f == null) {
            return new Cosine();
        }
        return new Cosine((Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "cos(x)" : "cos(" + this.f + ")";
    }
}

