/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.BinaryFunction;
import beowulf.model.math.function.Function;

public final class Difference
extends BinaryFunction {
    private static final long serialVersionUID = 3904961941091660085L;

    public static Function createDifference(Function function, Function function2) {
        if (Difference.isAdditiveIdentity(function2)) {
            return function;
        }
        return new Difference(function, function2);
    }

    public Difference() {
    }

    public Difference(Function function, Function function2) {
        super(function, function2);
    }

    public double evaluate(double d) {
        return this.f1.evaluate(d) - this.f2.evaluate(d);
    }

    public boolean isDifferentiable() {
        return this.f1.isDifferentiable() && this.f2.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = this.f1.getDerivative();
        Function function2 = this.f2.getDerivative();
        return Difference.createDifference(function, function2);
    }

    public Object clone() {
        return new Difference((Function)this.f1.clone(), (Function)this.f2.clone());
    }

    public String toString() {
        return "(" + this.f1 + " - " + this.f2 + ")";
    }
}

