/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Function;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FunctionTreeModel
implements TreeModel {
    protected Vector listeners;
    protected Function root;
    protected Hashtable parentTable = new Hashtable();
    protected Hashtable childTable = new Hashtable();

    public FunctionTreeModel() {
        this(null);
    }

    public FunctionTreeModel(Function function) {
        this.setRoot(function);
    }

    public void setRoot(Function function) {
        if (this.root != null) {
            this.clearSubtree(this.root);
        }
        this.root = function;
        if (this.root != null) {
            this.rebuildSubtree(this.root);
        }
        this.nodeStructureChanged(this.root);
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        Vector vector = (Vector)this.childTable.get(object);
        if (vector == null) {
            return null;
        }
        if (n < 0 || n >= vector.size()) {
            return null;
        }
        return vector.get(n);
    }

    public int getChildCount(Object object) {
        Vector vector = (Vector)this.childTable.get(object);
        if (vector == null) {
            return -1;
        }
        return vector.size();
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        Vector vector = (Vector)this.childTable.get(object);
        if (vector == null) {
            return -1;
        }
        return vector.indexOf(object2);
    }

    public Function getParent(Function function) {
        return (Function)this.parentTable.get(function);
    }

    public Function[] getPathToRoot(Function function) {
        return this.getPathToRoot(function, 0);
    }

    protected Function[] getPathToRoot(Function function, int n) {
        Function[] functionArray;
        if (function == null) {
            if (n == 0) {
                return null;
            }
            functionArray = new Function[n];
        } else {
            functionArray = function == this.root ? new Function[n] : this.getPathToRoot(this.getParent(function), ++n);
            functionArray[functionArray.length - n] = function;
        }
        return functionArray;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void insert(Function function, Function function2, int n) {
        Vector vector = (Vector)this.childTable.get(function);
        this.clearSubtree((Function)vector.get(n));
        vector.setElementAt(function2, n);
        this.parentTable.put(function2, function);
        function.setSubFunction(function2, n);
        this.rebuildSubtree(function2);
        this.nodeStructureChanged(function);
    }

    public void insert(Function function, Function function2) {
        Vector vector = (Vector)this.childTable.get(function);
        this.insert(function, function2, vector.size());
    }

    protected void nodesWereInserted(Function function, int[] nArray) {
        if (this.listeners == null || function == null) {
            return;
        }
        if (nArray == null || nArray.length <= 0) {
            return;
        }
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getChild(function, nArray[i]);
        }
        this.fireTreeNodesInserted(this, this.getPathToRoot(function), nArray, objectArray);
    }

    protected void nodesWereRemoved(Function function, int[] nArray, Object[] objectArray) {
        if (function == null || nArray == null) {
            return;
        }
        this.fireTreeNodesRemoved(this, this.getPathToRoot(function), nArray, objectArray);
    }

    public void nodeChanged(Function function) {
        if (this.listeners == null || function == null) {
            return;
        }
        Function function2 = this.getParent(function);
        if (function2 != null) {
            int n = this.getIndexOfChild(function2, function);
            if (n != -1) {
                this.nodesChanged(function2, new int[]{n});
            }
        } else if (function == this.root) {
            this.nodesChanged(function, null);
        }
    }

    protected void nodesChanged(Function function, int[] nArray) {
        if (function == null) {
            return;
        }
        if (nArray != null) {
            int n = nArray.length;
            if (n > 0) {
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = this.getChild(function, nArray[i]);
                }
                this.fireTreeNodesChanged(this, this.getPathToRoot(function), nArray, objectArray);
            }
        } else if (function == this.getRoot()) {
            this.fireTreeNodesChanged(this, this.getPathToRoot(function), null, null);
        }
    }

    protected void nodeStructureChanged(Function function) {
        if (function == null) {
            return;
        }
        this.fireTreeStructureChanged(this, this.getPathToRoot(function), null, null);
    }

    protected void clearSubtree(Function function) {
        Vector vector = (Vector)this.childTable.get(function);
        for (int i = 0; i < vector.size(); ++i) {
            this.clearSubtree((Function)vector.get(i));
        }
        this.childTable.remove(function);
        this.parentTable.remove(function);
    }

    protected void rebuildSubtree(Function function) {
        Vector<Function> vector = new Vector<Function>();
        this.childTable.put(function, vector);
        for (int i = 0; i < function.getSubFunctionCount(); ++i) {
            vector.add(function.getSubFunction(i));
            this.parentTable.put(function.getSubFunction(i), function);
            this.rebuildSubtree(function.getSubFunction(i));
        }
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (this.listeners == null) {
            return;
        }
        TreeModelEvent treeModelEvent = null;
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)this.listeners.get(i)).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (this.listeners == null) {
            return;
        }
        TreeModelEvent treeModelEvent = null;
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)this.listeners.get(i)).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (this.listeners == null) {
            return;
        }
        TreeModelEvent treeModelEvent = null;
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)this.listeners.get(i)).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        if (this.listeners == null) {
            return;
        }
        TreeModelEvent treeModelEvent = null;
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)this.listeners.get(i)).treeStructureChanged(treeModelEvent);
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.remove(treeModelListener);
    }
}

