/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Function;
import beowulf.model.math.function.Quotient;
import beowulf.model.math.function.UnaryFunction;

public final class Logarithm
extends UnaryFunction {
    private static final long serialVersionUID = 3618414908803659826L;

    public Logarithm() {
    }

    public Logarithm(Function function) {
        super(function);
    }

    public double evaluate(double d) {
        return Math.log(this.f.evaluate(d));
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        return Quotient.createQuotient(this.f.getDerivative(), (Function)this.f.clone());
    }

    public Object clone() {
        if (this.f == null) {
            return new Logarithm();
        }
        return new Logarithm((Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "log(x)" : "log(" + this.f + ")";
    }
}

