/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.BinaryFunction;
import beowulf.model.math.function.Constant;
import beowulf.model.math.function.Difference;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;

public final class Quotient
extends BinaryFunction {
    private static final long serialVersionUID = 3258126951381547060L;

    public static Function createQuotient(Function function, Function function2) {
        if (Quotient.isAdditiveIdentity(function)) {
            return new Constant(0.0);
        }
        if (Quotient.isMultiplicativeIdentity(function2)) {
            return function;
        }
        return new Quotient(function, function2);
    }

    public Quotient() {
    }

    public Quotient(Function function, Function function2) {
        super(function, function2);
    }

    public double evaluate(double d) {
        return this.f1.evaluate(d) / this.f2.evaluate(d);
    }

    public boolean isDifferentiable() {
        return this.f1.isDifferentiable() && this.f2.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = this.f1.getDerivative();
        Function function2 = (Function)this.f1.clone();
        Function function3 = this.f2.getDerivative();
        Function function4 = (Function)this.f2.clone();
        Function function5 = Product.createProduct(function, function4);
        Function function6 = Product.createProduct(function2, function3);
        Function function7 = Difference.createDifference(function5, function6);
        Function function8 = Product.createProduct((Function)this.f2.clone(), (Function)this.f2.clone());
        return Quotient.createQuotient(function7, function8);
    }

    public Object clone() {
        return new Quotient((Function)this.f1.clone(), (Function)this.f2.clone());
    }

    public String toString() {
        return "(" + this.f1 + " / " + this.f2 + ")";
    }
}

