/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.Cosine;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Product;
import beowulf.model.math.function.UnaryFunction;

public final class Sine
extends UnaryFunction {
    private static final long serialVersionUID = 3257846563014652217L;

    public Sine() {
    }

    public Sine(Function function) {
        super(function);
    }

    public double evaluate(double d) {
        return Math.sin(this.f.evaluate(d));
    }

    public boolean isDifferentiable() {
        return this.f == null || this.f.isDifferentiable();
    }

    public Function getDerivative() {
        return Product.createProduct(new Cosine((Function)this.f.clone()), this.f.getDerivative());
    }

    public Object clone() {
        if (this.f == null) {
            return new Sine();
        }
        return new Sine((Function)this.f.clone());
    }

    public String toString() {
        return this.f == null ? "sin(x)" : "sin(" + this.f + ")";
    }
}

