/*
 * Decompiled with CFR 0.152.
 */
package beowulf.model.math.function;

import beowulf.model.math.function.BinaryFunction;
import beowulf.model.math.function.Function;

public final class Sum
extends BinaryFunction {
    private static final long serialVersionUID = 3258132470447552821L;

    public static Function createSum(Function function, Function function2) {
        if (Sum.isAdditiveIdentity(function)) {
            return function2;
        }
        if (Sum.isAdditiveIdentity(function2)) {
            return function;
        }
        return new Sum(function, function2);
    }

    public Sum() {
    }

    public Sum(Function function, Function function2) {
        super(function, function2);
    }

    public double evaluate(double d) {
        return this.f1.evaluate(d) + this.f2.evaluate(d);
    }

    public boolean isDifferentiable() {
        return this.f1.isDifferentiable() && this.f2.isDifferentiable();
    }

    public Function getDerivative() {
        Function function = this.f1.getDerivative();
        Function function2 = this.f2.getDerivative();
        return Sum.createSum(function, function2);
    }

    public Object clone() {
        return new Sum((Function)this.f1.clone(), (Function)this.f2.clone());
    }

    public String toString() {
        return "(" + this.f1 + " + " + this.f2 + ")";
    }
}

