/*
 * Decompiled with CFR 0.152.
 */
package beowulf.util;

import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtility {
    public static String getAttribute(Element element, String string) {
        if (!element.hasAttribute(string)) {
            throw new RuntimeException("Missing " + string + " attribute in " + element.getNodeName() + " element");
        }
        return element.getAttribute(string);
    }

    public static String getAttribute(Element element, String string, String string2) {
        if (!element.hasAttributeNS(string, string2)) {
            throw new RuntimeException("Missing " + string + ":" + string2 + " attribute in " + element.getNodeName() + " element");
        }
        return element.getAttributeNS(string, string2);
    }

    public static Element fireElementNamed(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            return (Element)node2;
        }
        throw new RuntimeException("Missing " + string + " child element in " + node.getNodeName() + " element");
    }

    public static Element firstElementNamed(Node node, String string) {
        return DOMUtility.fireElementNamed(node, string, true);
    }

    public static Element fireElementNamed(Node node, String string, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            return (Element)node2;
        }
        if (bl) {
            throw new RuntimeException("Missing " + string + " child element in " + node.getNodeName() + " element");
        }
        return null;
    }

    public static Element firstElementNamed(Node node, String string, String string2) {
        return DOMUtility.firstElementNamed(node, string, string2, true);
    }

    public static Element firstElementNamed(Node node, String string, String string2, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNamespaceURI() == null && string != null || node2.getNamespaceURI() != null && string == null || string != null && !node2.getNamespaceURI().equals(string) || !node2.getLocalName().equals(string2)) continue;
            return (Element)node2;
        }
        if (bl) {
            throw new RuntimeException("Missing " + string + ":" + string2 + " child element in " + node.getNodeName() + " element");
        }
        return null;
    }

    public static Vector allElementsNamed(Node node, String string) {
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            vector.add(node2);
        }
        return vector;
    }

    public static Vector allElementsNamed(Node node, String string, String string2) {
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || node2.getNamespaceURI() == null && string != null || node2.getNamespaceURI() != null && string == null || string != null && !node2.getNamespaceURI().equals(string) || !node2.getLocalName().equals(string2)) continue;
            vector.add(node2);
        }
        return vector;
    }
}

