/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class AudioRecChunk
extends Chunk {
    public AudioRecChunk(AiffModule aiffModule, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(aiffModule, chunkHeader, dataInputStream);
    }

    public boolean readChunk(RepInfo repInfo) throws IOException {
        AiffModule aiffModule = (AiffModule)this._module;
        if (this.bytesLeft != 24L) {
            repInfo.setMessage((Message)new ErrorMessage("Audio Recording Chunk is incorrect size", aiffModule.getNByte()));
            repInfo.setWellFormed(false);
            return false;
        }
        byte[] byArray = new byte[24];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)aiffModule);
        aiffModule.addAiffProperty(new Property("AudioRecording", PropertyType.BYTE, PropertyArity.ARRAY, (Object)byArray));
        return true;
    }
}

