/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class CommonChunk
extends Chunk {
    public CommonChunk(AiffModule aiffModule, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(aiffModule, chunkHeader, dataInputStream);
    }

    public boolean readChunk(RepInfo repInfo) throws IOException {
        AiffModule aiffModule = (AiffModule)this._module;
        int n = aiffModule.readUnsignedShort(this._dstream);
        long l = aiffModule.readUnsignedInt(this._dstream);
        int n2 = aiffModule.readUnsignedShort(this._dstream);
        this.bytesLeft -= 8L;
        String string = null;
        String string2 = null;
        double d = aiffModule.read80BitDouble(this._dstream);
        this.bytesLeft -= 10L;
        if (aiffModule.getFileType() == 2) {
            if (this.bytesLeft == 0L) {
                repInfo.setMessage((Message)new ErrorMessage("Common Chunk in AIFF-C does not have compression type", aiffModule.getNByte()));
                repInfo.setWellFormed(false);
                return false;
            }
            string = aiffModule.read4Chars(this._dstream);
            if (string.equals("sowt")) {
                aiffModule.setEndian(false);
            }
            this.bytesLeft -= 4L;
            string2 = aiffModule.readPascalString(this._dstream);
            this.bytesLeft -= (long)(string2.length() + 1);
        }
        AESAudioMetadata aESAudioMetadata = aiffModule.getAESMetadata();
        aESAudioMetadata.setBitDepth(n2);
        aESAudioMetadata.setSampleRate(d);
        aESAudioMetadata.setNumChannels(n);
        this.setChannelLocations(aESAudioMetadata, n);
        aESAudioMetadata.setDuration(l);
        aiffModule.addAiffProperty(new Property("SampleFrames", PropertyType.LONG, (Object)new Long(l)));
        if (string != null) {
            aiffModule.addAiffProperty(new Property("CompressionType", PropertyType.STRING, (Object)string));
            if (!string.equals("NONE")) {
                if (string.equals("raw ")) {
                    aESAudioMetadata.setAudioDataEncoding("PCM 8-bit offset-binary");
                } else if (string.equals("twos")) {
                    aESAudioMetadata.setAudioDataEncoding("PCM 16-bit twos-complement big-endian");
                } else if (string.equals("sowt")) {
                    aESAudioMetadata.setAudioDataEncoding("PCM 16-bit twos-complement little-endian");
                } else if (string.equals("fl32")) {
                    aESAudioMetadata.setAudioDataEncoding("PCM 32-bit integer");
                } else if (string.equals("fl64")) {
                    aESAudioMetadata.setAudioDataEncoding("PCM 64-bit floating point");
                } else if (string.equals("in24")) {
                    aESAudioMetadata.setAudioDataEncoding("PCM 24-bit integer");
                } else if (string.equals("in32")) {
                    aESAudioMetadata.setAudioDataEncoding("PCM 32-bit integer");
                } else {
                    aESAudioMetadata.setAudioDataEncoding(string2);
                    String string3 = string2;
                    if (string3 == null || string3.length() == 0) {
                        string3 = string;
                    }
                    aESAudioMetadata.setBitrateReduction(string2, "", "", "", "LOSSY", "UNKNOWN", "FIXED");
                }
            }
        }
        if (string2 != null && string2.length() > 0) {
            aiffModule.addAiffProperty(new Property("CompressionName", PropertyType.STRING, (Object)string2));
        }
        return true;
    }

    private void setChannelLocations(AESAudioMetadata aESAudioMetadata, int n) {
        String[] stringArray = new String[n];
        switch (n) {
            case 1: {
                stringArray[0] = "UNKNOWN";
                break;
            }
            case 4: {
                stringArray[3] = "SURROUND";
            }
            case 3: {
                stringArray[2] = "CENTER";
            }
            case 2: {
                stringArray[0] = "LEFT";
                stringArray[1] = "RIGHT";
                break;
            }
            case 6: {
                stringArray[0] = "LEFT";
                stringArray[1] = "LEFT_CENTER";
                stringArray[2] = "CENTER";
                stringArray[3] = "RIGHT";
                stringArray[4] = "RIGHT_CENTER";
                stringArray[5] = "SURROUND";
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = "UNKNOWN";
                }
            }
        }
        aESAudioMetadata.setMapLocations(stringArray);
    }
}

