/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class FragmentListBox
extends JP2Box {
    private List _fragmentList;

    public FragmentListBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    public boolean readBox() throws IOException {
        if (!this._module.isJP2HdrSeen()) {
            this._repInfo.setMessage((Message)new ErrorMessage("Other boxes may not occur before JP2 Header", this._module.getFilePos()));
            return false;
        }
        this.initBytesRead();
        int n = (int)this._boxHeader.getDataLength();
        int n2 = this._module.readUnsignedShort(this._dstrm);
        if (this._boxHeader.getLength() != 0L && n != 14 * n2 + 2) {
            this._repInfo.setMessage((Message)new ErrorMessage("Fragment Table has invalid length", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        this._fragmentList = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            long l = this._module.readSignedLong(this._dstrm);
            long l2 = this._module.readUnsignedInt(this._dstrm);
            int n3 = this._module.readUnsignedShort(this._dstrm);
            if (n3 != 0) {
                this._fragmentList = null;
                this._repInfo.setMessage((Message)new InfoMessage("Document references an external file", this._module.getFilePos()));
                continue;
            }
            if (this._fragmentList == null) continue;
            long[] lArray = new long[]{l, l2};
            this._fragmentList.add(lArray);
        }
        this.finalizeBytesRead();
        return true;
    }

    protected List getFragmentList() {
        return this._fragmentList;
    }

    protected String getSelfPropName() {
        return "Fragment List Box";
    }
}

