/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfProfile;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import java.util.Vector;

public abstract class XProfileBase
extends PdfProfile {
    public static int PDFX1 = 1;
    public static int PDFX1A = 2;
    public static int PDFX2 = 3;
    public static int PDFX3 = 4;
    protected int _xType;
    protected boolean _bleedBoxPresent = false;

    public XProfileBase(PdfModule pdfModule, int n) {
        super(pdfModule);
        this._xType = n;
    }

    protected boolean infoDictOK(String string) {
        PdfDictionary pdfDictionary = this._module.getDocInfo();
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Trapped");
            PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary.get("GTS_PDFXVersion");
            if (pdfDictionary.get("CreationDate") == null || pdfSimpleObject2 == null || pdfDictionary.get("ModDate") == null || pdfDictionary.get("Title") == null || pdfSimpleObject == null) {
                return false;
            }
            String string2 = pdfSimpleObject.getStringValue();
            if (!"True".equals(string2) && !"False".equals(string2)) {
                return false;
            }
            String string3 = pdfSimpleObject2.getStringValue();
            if (!string3.startsWith(string)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean isBleedBoxPresent() {
        return this._bleedBoxPresent;
    }

    protected boolean outputIntentsOK(PdfArray pdfArray) {
        Vector vector = pdfArray.getContent();
        int n = 0;
        try {
            for (int i = 0; i < vector.size(); ++i) {
                String string;
                PdfDictionary pdfDictionary = (PdfDictionary)this._module.resolveIndirectObject((PdfObject)vector.elementAt(i));
                PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)this._module.resolveIndirectObject(pdfDictionary.get("S"));
                if (pdfSimpleObject == null || !"GTS_PDFX".equals(string = pdfSimpleObject.getStringValue())) continue;
                ++n;
                PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)this._module.resolveIndirectObject(pdfDictionary.get("OutputConditionIdentifier"));
                if (pdfSimpleObject2 == null) {
                    return false;
                }
                if (this._xType != PDFX1) continue;
                PdfSimpleObject pdfSimpleObject3 = (PdfSimpleObject)this._module.resolveIndirectObject(pdfDictionary.get("RegistryName"));
                PdfStream pdfStream = (PdfStream)this._module.resolveIndirectObject(pdfDictionary.get("DestOutputProfile"));
                if (pdfSimpleObject3 != null || pdfStream != null) continue;
                return false;
            }
            return n == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean trailerDictOK() {
        PdfDictionary pdfDictionary = this._module.getTrailerDict();
        if (pdfDictionary == null) {
            return false;
        }
        return pdfDictionary.get("ID") != null;
    }

    protected boolean extGStateOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return true;
        }
        try {
            PdfObject pdfObject;
            PdfSimpleObject pdfSimpleObject;
            int n;
            PdfObject pdfObject2 = pdfDictionary.get("TR");
            PdfObject pdfObject3 = pdfDictionary.get("TR2");
            PdfObject pdfObject4 = pdfDictionary.get("HTP");
            if (pdfObject2 != null || pdfObject3 != null || pdfObject4 != null) {
                return false;
            }
            PdfObject pdfObject5 = pdfDictionary.get("HT");
            if (pdfObject5 instanceof PdfDictionary && (n = (pdfSimpleObject = (PdfSimpleObject)((PdfDictionary)(pdfObject = (PdfDictionary)pdfObject5)).get("HalftoneType")).getIntValue()) != 1 && n != 5) {
                return false;
            }
            if (pdfDictionary.get("HalftoneName") != null) {
                return false;
            }
            if (this._xType == PDFX1A || this._xType == PDFX2) {
                double d;
                String string;
                pdfObject = (PdfSimpleObject)pdfDictionary.get("SMask");
                if (pdfObject != null && !"None".equals(((PdfSimpleObject)pdfObject).getStringValue())) {
                    return false;
                }
                pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("BM");
                if (pdfSimpleObject != null && !"Normal".equals(string = pdfSimpleObject.getStringValue()) && !"Compatible".equals(string)) {
                    return false;
                }
                PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary.get("CA");
                if (pdfSimpleObject2 != null && (d = pdfSimpleObject2.getDoubleValue()) != 1.0) {
                    return false;
                }
                pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary.get("ca");
                if (pdfSimpleObject2 != null && (d = pdfSimpleObject2.getDoubleValue()) != 1.0) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean xObjectOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return true;
        }
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Subtype");
            if (pdfSimpleObject != null) {
                String string = pdfSimpleObject.getStringValue();
                if ("PS".equals(string)) {
                    return false;
                }
                if ("Image".equals(string) && !this.imageObjectOK(pdfDictionary)) {
                    return false;
                }
                if ("Form".equals(string) && !this.formObjectOK(pdfDictionary)) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean imageObjectOK(PdfDictionary pdfDictionary) {
        try {
            PdfSimpleObject pdfSimpleObject;
            PdfArray pdfArray = (PdfArray)pdfDictionary.get("Alternates");
            if (pdfArray == null) {
                return true;
            }
            Vector vector = pdfArray.getContent();
            for (int i = 0; i < vector.size(); ++i) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)vector.elementAt(i);
                PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary2.get("DefaultForPrinting");
                if (!pdfSimpleObject2.isTrue()) continue;
                return false;
            }
            if (this._xType == PDFX2 && pdfDictionary.get("OPI") != null) {
                return false;
            }
            if (!(this._xType != PDFX1A && this._xType != PDFX2 || (pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("SMask")) == null || "None".equals(pdfSimpleObject.getStringValue()))) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean formObjectOK(PdfDictionary pdfDictionary) {
        return true;
    }

    protected boolean bboxOK(boolean bl) {
        PageTreeNode pageTreeNode = this._module.getDocumentTree();
        try {
            PageObject pageObject;
            pageTreeNode.startWalk();
            while ((pageObject = pageTreeNode.nextPageObject()) != null) {
                PdfArray pdfArray;
                if (bl && (pdfArray = pageObject.getMediaBox()) == null) {
                    return false;
                }
                pdfArray = pageObject.getTrimBox();
                PdfArray pdfArray2 = pageObject.getArtBox();
                if (pdfArray == null && pdfArray2 == null) {
                    return false;
                }
                if (pdfArray != null && pdfArray2 != null) {
                    return false;
                }
                if (pageObject.getBleedBox() == null) continue;
                this._bleedBoxPresent = true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean checkPrefsAgainstBleedBox() {
        if (!this._bleedBoxPresent) {
            return true;
        }
        PdfDictionary pdfDictionary = this._module.getViewPrefDict();
        if (pdfDictionary == null) {
            return true;
        }
        try {
            PdfSimpleObject[] pdfSimpleObjectArray = new PdfSimpleObject[]{(PdfSimpleObject)pdfDictionary.get("ViewArea"), (PdfSimpleObject)pdfDictionary.get("ViewClip"), (PdfSimpleObject)pdfDictionary.get("PrintArea")};
            for (int i = 0; i < 3; ++i) {
                String string;
                if (pdfSimpleObjectArray[i] == null || "MediaBox".equals(string = pdfSimpleObjectArray[i].getStringValue()) || "BleedBox".equals(string)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean filterOK(PdfObject pdfObject, boolean bl, boolean bl2) {
        try {
            if (pdfObject == null) {
                return true;
            }
            if (pdfObject instanceof PdfSimpleObject) {
                String string = ((PdfSimpleObject)pdfObject).getStringValue();
                if ("LZWDecode".equals(string)) {
                    return false;
                }
            } else {
                Vector vector = ((PdfArray)pdfObject).getContent();
                for (int i = 0; i < vector.size(); ++i) {
                    PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)vector.elementAt(i);
                    String string = pdfSimpleObject.getStringValue();
                    if (bl && "LZWDecode".equals(string)) {
                        return false;
                    }
                    if (!bl2 || !"JBIG2Decode".equals(string)) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

