/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITBL
extends TiffProfileClassIT {
    public TiffProfileClassITBL() {
        this._profileText = "TIFF/IT-BL (ISO 12639:1998)";
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray[0] != 1) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, 32898)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, 1)) {
            return false;
        }
        int[] nArray2 = tiffIFD.getImageColorValue() != -1 ? new int[]{1} : new int[]{0, 1, 2};
        if (!this.satisfiesImageColorIndicator(tiffIFD, nArray2)) {
            return false;
        }
        nArray2 = tiffIFD.getBackgroundColorValue() != -1 ? new int[]{1} : new int[]{0, 1, 2};
        return this.satisfiesBackgroundColorIndicator(tiffIFD, nArray2);
    }
}

