/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITFPP1
extends TiffProfileClassIT {
    public TiffProfileClassITFPP1() {
        this._profileText = "TIFF/IT-FP/P1 (ISO 12639:1998)";
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (tiffIFD.getImageDescription() == null || tiffIFD.getXPosition() == null || tiffIFD.getYPosition() == null) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (!(nArray == null || nArray.length == 1 && (nArray[0] == 4 || nArray[0] == 8) || nArray.length == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8 || nArray.length == 4 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8 && nArray[3] == 8)) {
            return false;
        }
        long l = tiffIFD.getNewSubfileType();
        if ((l & 8L) == 0L) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{0, 1, 2, 5})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, new int[]{3, 4, -1})) {
            return false;
        }
        if (!this.satisfiesOrientation(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesPlanarConfiguration(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, 1)) {
            return false;
        }
        int n = nisoImageMetadata.getColorSpace();
        int n2 = tiffIFD.getNumberOfInks();
        if (!(n != 5 || n2 == 4 && this.satisfiesDotRange(tiffIFD, 0, 255))) {
            return false;
        }
        return tiffIFD.getDocumentName() == null && nisoImageMetadata.getScannerModelName() == null && tiffIFD.getPageName() == null && nisoImageMetadata.getHostComputer() == null && tiffIFD.getSite() == null;
    }
}

